/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.index.Index;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.index.sending.IIndexService;

public class ReadArchiveJob
extends BackendJobBase {
    private final int year;
    private volatile Index archivePart;

    public ReadArchiveJob(int year) {
        super(IConfigService.Module.moduleExport);
        this.year = year;
    }

    @Override
    public void done() {
        Services.get(IIndexService.class).archiveChanged(this.year, this.archivePart);
    }

    @Override
    public void execute() throws Exception {
        this.archivePart = IndexUtil.readArchive(this.year);
    }

    @Override
    public String getMessage() {
        return Services.getText(863);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.format(864, Services.getText(102) + " -> " + Services.getText(871)));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

