/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.masterdata.DataNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.masterdata.DataAction;
import ch.transsoft.edec.service.masterdata.IDataFile;
import ch.transsoft.edec.util.Check;

public class ReadMasterDataJob<T extends DataNode<T>>
extends BackendJobBase {
    private final DataAction<T> action;
    private T masterData;
    private final IDataFile<T> type;
    private final boolean showWaitCursor;

    public ReadMasterDataJob(IDataFile<T> dataFile, boolean showWaitCursor, DataAction<T> action) {
        super(IConfigService.Module.moduleExport);
        Check.assertNotNull(dataFile);
        Check.assertNotNull(action);
        this.type = dataFile;
        this.showWaitCursor = showWaitCursor;
        this.action = action;
    }

    @Override
    public void execute() throws Exception {
        this.masterData = this.readMasterData(this.type);
    }

    public String getErrorMessage() {
        return Services.getText(601) + " " + this.type.getLabel();
    }

    public T getEmptyObject() {
        return (T)((DataNode)NodeFactory.create(this.type.contentType()));
    }

    @Override
    public void done() {
        this.action.handle(this.masterData == null ? this.getEmptyObject() : this.masterData);
    }

    @Override
    public String getMessage() {
        return Services.getText(867) + " " + this.type.getLabel();
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(601));
        this.done();
    }

    @Override
    public boolean showWaitCursor() {
        return this.showWaitCursor;
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

