/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.masterdata.Currencies;
import ch.transsoft.edec.model.masterdata.Currency;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdata.IDataService;

public class SaveCurrencyJob
extends BackendJobBase {
    private volatile Currencies data;
    private final String currencyName;
    private final Number currencyRate;

    public SaveCurrencyJob(String currency, Number rate) {
        super(IConfigService.Module.moduleExport);
        this.currencyName = currency;
        this.currencyRate = rate;
    }

    @Override
    public void done() {
        if (this.data == null) {
            return;
        }
        Services.get(IDataService.class).setMasterData(this.data);
    }

    @Override
    public void execute() throws Exception {
        this.data = this.readMasterData(DataFiles.currency);
        if (this.data == null) {
            return;
        }
        Currency match = this.findCurrency();
        if (match != null) {
            match.getRate().setValue(this.currencyRate);
        } else {
            Currency newCurrency = NodeFactory.create(Currency.class);
            newCurrency.getName().setValue(this.currencyName);
            newCurrency.getRate().setValue(this.currencyRate);
            this.data.getCurrencyList().add(newCurrency);
        }
        this.writeMasterData(this.data);
    }

    private Currency findCurrency() {
        for (Currency current : this.data.getCurrencyList()) {
            if (!current.getName().getValue().equals(this.currencyName)) continue;
            return current;
        }
        return null;
    }

    @Override
    public String getMessage() {
        return Services.getText(873);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(874));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

