/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.masterdata.GoodsItems;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.ui.pm.sending.itemlist.action.SaveInMasterdataAction;
import ch.transsoft.edec.util.DateUtil;

public class SaveGoodsItemJob
extends BackendJobBase {
    private final GoodsItem goodsItem;
    private volatile GoodsItems data;
    private final SaveInMasterdataAction saveInMasterdataAction;

    public SaveGoodsItemJob(SaveInMasterdataAction saveInMasterdataAction, GoodsItem goodsItem) {
        super(IConfigService.Module.moduleExport);
        this.saveInMasterdataAction = saveInMasterdataAction;
        if (!goodsItem.getId().isInitialized()) {
            goodsItem.getId().setValue(DateUtil.createId());
        }
        this.goodsItem = (GoodsItem)goodsItem.getCopy((ModelNode)null);
    }

    @Override
    public void done() {
        if (this.data == null) {
            return;
        }
        Services.get(IDataService.class).setMasterData(this.data);
        this.saveInMasterdataAction.updateSaveButtonState();
    }

    @Override
    public void execute() throws Exception {
        this.data = this.readMasterData(DataFiles.goodsItem);
        if (this.data == null) {
            return;
        }
        this.repairData();
        this.data.addOrReplace(this.goodsItem);
        this.writeMasterData(this.data);
    }

    private void repairData() {
        Long q;
        if (this.goodsItem.getGoodsData().getQuantity().isInitialized() && (q = this.goodsItem.getGoodsData().getQuantity().getValue()) > 1L) {
            this.repairValues(this.goodsItem.getGoodsData(), q);
        }
        this.goodsItem.getGoodsData().getCurrency().clear();
        this.goodsItem.getGoodsData().getCurrencyRate().clear();
        this.goodsItem.getGoodsData().getTraderItemID().clear();
        this.goodsItem.getGoodsData().getQuantity().clear();
        this.goodsItem.getGoodsData().getPackagingReferenceNumber().clear();
    }

    private void repairValues(GoodsData d2, Long q) {
        if (d2.getGrossMass().isInitialized()) {
            d2.getGrossMass().setValue(d2.getGrossMass().getValue() / (double)q.longValue());
        }
        if (d2.getNetMass().isInitialized()) {
            d2.getNetMass().setValue(d2.getNetMass().getValue() / (double)q.longValue());
        }
        if (d2.getStatisticalValue().isInitialized()) {
            d2.getStatisticalValue().setValue(d2.getStatisticalValue().getValue() / (double)q.longValue());
        }
        if (d2.getAdditionalUnit().isInitialized()) {
            d2.getAdditionalUnit().setValue(d2.getAdditionalUnit().getValue() / (double)q.longValue());
        }
    }

    @Override
    public String getMessage() {
        return Services.getText(875);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(876));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

