/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.manip.ISendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.SendingManipJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.webservices.mail.CarrierMail;
import ch.transsoft.edec.service.webservices.mail.SendMailToCarrierFacade;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;
import ch.transsoft.edec.util.SendingUtil;
import jakarta.xml.ws.WebServiceException;
import java.io.File;
import java.net.ConnectException;

public class SendMailViaTransSoftServerJob
extends SendingManipJobBase {
    private final ListNode<AttachmentEntry> attachments;
    private final CarrierMail mail;
    private final ISendingManip sendingManip;
    private final String guid;
    private final File attachmentCopyTargetFolder;
    private final boolean copyAttachments;

    public SendMailViaTransSoftServerJob(Sending sending, CarrierMail mail, ListNode<AttachmentEntry> attachments, ISendingManip sendingManip, boolean copyAttachments) {
        super(sending);
        this.attachmentCopyTargetFolder = SendingUtil.getSendingDir(sending.getSendingId(), false);
        this.mail = mail;
        this.attachments = attachments;
        this.sendingManip = sendingManip;
        this.copyAttachments = copyAttachments;
        this.guid = Services.get(IConfigService.class).getGuid();
    }

    @Override
    protected ISendingManip doExecute(Sending backgroundSending) throws Exception {
        if (this.copyAttachments) {
            for (AttachmentEntry attachment : this.attachments) {
                attachment.copyToSendingFolder(this.attachmentCopyTargetFolder);
            }
        }
        SendMailToCarrierFacade.send(this.guid, this.mail);
        return this.sendingManip;
    }

    @Override
    public String getMessage() {
        return Services.getText(885);
    }

    @Override
    protected void handleErrorForCurrentSending(Sending sending, Throwable e2) {
        this.internalHandleError(e2);
    }

    @Override
    protected void handleErrorForSavedSending(String sendingId, Throwable e2) {
        this.internalHandleError(e2);
    }

    private void internalHandleError(Throwable e2) {
        if (e2 instanceof WebServiceException && e2.getCause() instanceof ConnectException) {
            this.log(e2.getCause(), Services.getText(622) + "\n" + Services.getText(623));
            return;
        }
        this.log(e2, Services.getText(886));
    }

    @Override
    protected boolean cancelExecute(Sending backgroundSending) {
        return this.isSendingInConflict();
    }
}

