/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.manip.ISendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.NullSendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.SendingManipJobBase;
import ch.transsoft.edec.service.ezv.evv.sigcheck.DocumentValidator;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.SendingUtil;
import java.io.File;

public class ValidateEvvJob
extends SendingManipJobBase {
    public ValidateEvvJob(String sendingId) {
        super(sendingId);
    }

    @Override
    protected boolean cancelExecute(Sending backgroundSending) throws Exception {
        return this.isSendingInConflict();
    }

    @Override
    protected ISendingManip doExecute(Sending backgroundSending) throws Exception {
        if (!backgroundSending.getState().hasEvv()) {
            return new NullSendingManip();
        }
        File evvDir = SendingUtil.getEvvPath(backgroundSending.getSendingId(), false);
        boolean result = DocumentValidator.validateFromFile(evvDir, backgroundSending.getSendingId());
        return sending -> sending.getState().setEvvValid(result);
    }

    @Override
    public String getMessage() {
        return Services.getText(887);
    }

    @Override
    protected void handleErrorForCurrentSending(Sending sending, Throwable e2) {
        this.handleErrorForSavedSending(sending.getSendingId(), e2);
    }

    @Override
    protected void handleErrorForSavedSending(String sendingId, Throwable e2) {
        Services.get(ILoggingService.class).logAndReport(e2, Services.getText(641));
    }
}

