/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.demodata;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class DeployDemoData
extends BackendJobBase {
    private volatile boolean templatesAdded = false;

    public DeployDemoData() {
        super(IConfigService.Module.moduleExport);
    }

    @Override
    public void done() {
        if (this.templatesAdded) {
            Services.get(IGuiService.class).refreshTemplateModel();
        }
    }

    @Override
    public void execute() throws Exception {
        this.copyTemplates();
        this.copyMasterdata();
    }

    private void copyMasterdata() throws IOException {
        File dir = this.getConfigService().getMasterDataDir(false);
        if (dir.list().length != 0) {
            return;
        }
        this.copy("GoodsItems.xml", dir);
        this.copy("Currencies.xml", dir);
    }

    private void copyTemplates() throws IOException {
        File dir = this.getConfigService().getTemplateDir(false);
        if (dir.list() != null && dir.list().length != 0) {
            return;
        }
        this.copy("Absendervorlage.xml", dir);
        this.copy("Mustervorlage ohne Warendaten.xml", dir);
        this.copy("Mustervorlage mit Warendaten.xml", dir);
        this.templatesAdded = true;
    }

    private void copy(String fileName, File templateDir) throws IOException {
        FileUtil.copy(this.getClass().getResourceAsStream("data/" + fileName), new File(templateDir, fileName));
    }

    private IConfigService getConfigService() {
        return Services.get(IConfigService.class);
    }

    @Override
    public String getMessage() {
        return Services.getText(810);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(811));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

