/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.edecmail;

import ch.transsoft.edec.model.index.Index;
import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.edecmail.PollStatusEmailJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.webservices.customermgmt.CustomerManagementFacade;
import ch.transsoft.edec.util.Check;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetStatusEmailListJob
extends BackendJobBase {
    private final String guid;
    private List<String> result;
    private final Map<String, IndexEntry> entryIndex = new HashMap<String, IndexEntry>();

    public GetStatusEmailListJob() {
        super(IConfigService.Module.moduleExport);
        this.guid = Services.get(IConfigService.class).getGuid();
    }

    @Override
    public void done() {
        if (this.result == null) {
            return;
        }
        for (String customsDeclarationNumber : this.result) {
            IndexEntry current = this.entryIndex.get(customsDeclarationNumber);
            if (current != null) {
                Check.assertNotNull(current.getSendingId());
                Services.get(IBackendService.class).put(new PollStatusEmailJob(current.getSendingId(), this.guid, customsDeclarationNumber));
                continue;
            }
            Services.get(ILoggingService.class).logSilent("Sending not found for StatusEmail: " + customsDeclarationNumber);
        }
    }

    @Override
    public void execute() throws Exception {
        Index index = IndexUtil.readIndex();
        this.addIndexEntriesToMap(index);
        this.result = CustomerManagementFacade.getStatusEmailList(this.guid);
    }

    private void addIndexEntriesToMap(Index index) {
        for (IndexEntry current : index.getEntryList()) {
            this.entryIndex.put(current.getCustomsDeclarationNumber().getValue(), current);
        }
    }

    @Override
    public String getMessage() {
        return Services.getText(812);
    }

    @Override
    public void handleError(Throwable e2) {
        Services.get(ILoggingService.class).logSilentWithBugMail(e2, "failed getting StatusEmail");
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

