/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evv;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.ISendingHandler;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.dialog.export.evvexport.pm.ExpColDesc;
import ch.transsoft.edec.ui.dialog.export.evvexport.pm.ExpXmlDomWrapper;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class ExtractEvvExportJob
extends BackendJobBase
implements ISendingHandler {
    private final Date from;
    private final Date to;
    private final String delimiterStr;
    private final boolean showHeader;
    private final File file;
    private final List<File> evvPaths = new ArrayList<File>();
    private final List<ExpColDesc> headers;
    private final List<ExpColDesc> items;

    public ExtractEvvExportJob(List<ExpColDesc> headers, List<ExpColDesc> items, Date from, Date to, String delimiterStr, boolean showHeader, File file) {
        super(IConfigService.Module.moduleImport);
        this.headers = headers;
        this.items = items;
        this.from = from;
        this.to = DateUtil.getEndOfDay(to);
        this.delimiterStr = delimiterStr;
        this.showHeader = showHeader;
        this.file = file;
    }

    @Override
    public void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        this.addAllEvvsToList();
        ArrayList<String> result = new ArrayList<String>();
        if (this.showHeader) {
            result.add(this.getHeaderLine());
        }
        for (File current : this.evvPaths) {
            this.addLines(current, result);
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.ISO_8859_1));
            for (String line : result) {
                out.write(line + "\n");
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(out);
    }

    public String getHeaderLine() {
        StringBuilder result = new StringBuilder();
        this.addHeaders(this.headers, result);
        this.addHeaders(this.items, result);
        return result.toString();
    }

    private void addHeaders(List<ExpColDesc> descs, StringBuilder result) {
        for (ExpColDesc desc : descs) {
            if (!desc.isEnabled()) continue;
            if (result.length() != 0) {
                result.append(this.delimiterStr);
            }
            result.append(desc.getCaption());
        }
    }

    private void addLines(File evvPath, List<String> result) throws Exception {
        try {
            Document evvDoc = DocumentUtil.readXmlDoc(evvPath);
            ExpXmlDomWrapper wrapper = new ExpXmlDomWrapper(evvDoc, this.headers, this.items, ";");
            Date date = wrapper.getAcceptanceDate();
            if (date.after(this.from) && date.before(this.to) || date.equals(this.from) || date.equals(this.to)) {
                wrapper.addLines(result);
            }
        }
        catch (SAXParseException e2) {
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(4713) + "\n" + evvPath.toString());
        }
    }

    private void addAllEvvsToList() {
        for (int year = DateUtil.getYear(this.from) - 1; year <= DateUtil.getYear(this.to); ++year) {
            SendingUtil.handleSendingsOfOneYear(this, year);
        }
    }

    @Override
    public void handle(File dir, File path, String yearPart, String sendingPart) {
        File evvPath = new File(dir, "evv.xml");
        if (!evvPath.exists()) {
            return;
        }
        this.evvPaths.add(evvPath);
    }

    @Override
    public String getMessage() {
        return Services.getText(4750);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, new String[0]);
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

