/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evv;

import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.EVVState;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.MoveSendingToArchiveJob;
import ch.transsoft.edec.service.backend.jobs.evv.FetchEvvJobErrorHandler;
import ch.transsoft.edec.service.backend.jobs.manip.ISendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.SendingManipJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.ezv.evv.EvvResponse;
import ch.transsoft.edec.util.Check;

public class FetchEvvJob
extends SendingManipJobBase {
    private final OperatingMode mode;
    private final String customsDeclarationNumber;
    private final FetchEvvJobErrorHandler errorHandler;

    public FetchEvvJob(OperatingMode mode, String sendingId, String customsDeclarationNumber, boolean silent) {
        super(sendingId);
        Check.assertNotNull((Object)mode);
        Check.assertNotNull(customsDeclarationNumber);
        this.errorHandler = new FetchEvvJobErrorHandler(silent);
        this.mode = mode;
        this.customsDeclarationNumber = customsDeclarationNumber;
    }

    @Override
    public void done() {
        super.done();
        if (this.isJobWasCanceled()) {
            return;
        }
        if (Services.get(IConfigService.class).getOptionInfo().getEvvInfo().getAutoArchive().getValue().booleanValue()) {
            Services.get(IBackendService.class).jam(new MoveSendingToArchiveJob(this.getSendingId()));
        }
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    protected ISendingManip doExecute(Sending backgroundSending) throws Exception {
        StringNode uidNode = backgroundSending.getGoodsDeclaration().getDeclarant().getUid();
        String uid = uidNode == null || !uidNode.isInitialized() ? Services.get(IConfigService.class).getEdecExportIdentification() : uidNode.getValue();
        EvvResponse evv = Services.get(IEZVService.class).getEvv(this.mode, uid, this.customsDeclarationNumber, null, ReceiptDocumentType.vve);
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        boolean evvValid = this.saveEvvToDisk(this.getSendingId(), evv);
        return sending -> {
            sending.addHistoryEntry("eVV fetched");
            sending.getState().setEvvState(EVVState.complete);
            sending.getState().setEvvValid(evvValid);
            sending.getAcceptanceDate().setValue(this.getAcceptanceDate(evv.getResponse()), true);
        };
    }

    @Override
    public String getMessage() {
        return Services.getText(819) + this.customsDeclarationNumber;
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public boolean locksActions() {
        return false;
    }

    @Override
    protected boolean cancelExecute(Sending backgroundSending) throws Exception {
        return this.isSendingInConflict();
    }

    @Override
    protected void handleErrorForCurrentSending(Sending sending, Throwable e2) {
        this.errorHandler.handleError(e2);
    }

    @Override
    protected void handleErrorForSavedSending(String sendingId, Throwable e2) {
        this.errorHandler.handleError(e2);
    }
}

