/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evv;

import ch.e_dec.services.edecreceiptservice.v3.ReceiptRequestFault;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.ezv.evv.EvvErrorHandler;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.Check;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.net.ConnectException;
import java.net.UnknownHostException;

public class FetchEvvJobErrorHandler {
    private final boolean silent;

    public FetchEvvJobErrorHandler(boolean silent) {
        this.silent = silent;
    }

    public void handleError(Throwable e2) {
        if (this.silent) {
            Services.get(ILoggingService.class).logSilent(e2, "Error while fetching eVVs");
            return;
        }
        if (e2 instanceof WebServiceException) {
            if (e2.getCause() instanceof UnknownHostException) {
                Services.get(ILoggingService.class).logAndReport(e2.getCause(), Services.getText(627) + "\n" + Services.getText(623));
                return;
            }
            if (e2.getCause() instanceof ConnectException) {
                Services.get(ILoggingService.class).logAndReport(e2.getCause(), Services.getText(627) + "\n" + Services.getText(623));
                return;
            }
            if (e2 instanceof SOAPFaultException) {
                Services.get(ILoggingService.class).logAndReport(e2, Services.getText(627) + "\n" + Services.getText(623));
                return;
            }
            Services.get(ILoggingService.class).logAndReport(e2, Services.getText(627) + "\n" + Services.getText(623));
            return;
        }
        if (e2 instanceof ReceiptRequestFault) {
            new EvvErrorHandler((ReceiptRequestFault)e2);
        } else {
            Check.fail(e2, Services.getText(823));
        }
    }
}

