/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evv;

import ch.transsoft.edec.model.sending.EVVState;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.MoveSendingToArchiveJob;
import ch.transsoft.edec.service.backend.jobs.manip.ISendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.SendingManipJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.evv.EvvResponse;
import ch.transsoft.edec.util.Check;

public class SaveEvvJob
extends SendingManipJobBase {
    private final String customsDeclarationNumber;
    private final EvvResponse evvResponse;

    public SaveEvvJob(String sendingId, String customsDeclarationNumber, EvvResponse evvResponse) {
        super(sendingId);
        Check.assertNotNull(customsDeclarationNumber);
        Check.assertNotNull(evvResponse);
        this.customsDeclarationNumber = customsDeclarationNumber;
        this.evvResponse = evvResponse;
    }

    @Override
    public void done() {
        super.done();
        if (this.isJobWasCanceled()) {
            return;
        }
        if (Services.get(IConfigService.class).getOptionInfo().getEvvInfo().getAutoArchive().getValue().booleanValue()) {
            Services.get(IBackendService.class).put(new MoveSendingToArchiveJob(this.getSendingId()), true);
        }
    }

    @Override
    protected ISendingManip doExecute(Sending backgroundSending) throws Exception {
        final boolean evvValid = this.saveEvvToDisk(this.getSendingId(), this.evvResponse);
        return new ISendingManip(){

            @Override
            public void execute(Sending sending) {
                sending.addHistoryEntry("eVV fetched");
                sending.getState().setEvvState(EVVState.complete);
                sending.getState().setEvvValid(evvValid);
                sending.getAcceptanceDate().setValue(SaveEvvJob.this.getAcceptanceDate(SaveEvvJob.this.evvResponse.getResponse()), true);
            }
        };
    }

    @Override
    public String getMessage() {
        return Services.getText(819) + this.customsDeclarationNumber;
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public boolean locksActions() {
        return false;
    }

    @Override
    protected boolean cancelExecute(Sending backgroundSending) throws Exception {
        return this.isSendingInConflict();
    }

    @Override
    protected void handleErrorForCurrentSending(Sending sending, Throwable e2) {
        this.handleErrorForSavedSending(sending.getSendingId(), e2);
    }

    @Override
    protected void handleErrorForSavedSending(String sendingId, Throwable e2) {
        this.log(e2, Services.getText(880));
    }
}

