/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.ArchiveMultipleBordereauxJob;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ArchiveMultipleReceiptsJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.autoarchive.AutoArchiveDialog;
import ch.transsoft.edec.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class AutoArchiveJob
extends BackendJobBase {
    private static final int MAX_AGE = 30;
    private volatile List<BordereauEntry> bordereaux = new ArrayList<BordereauEntry>();
    private volatile List<ReceiptEntry> receipts = new ArrayList<ReceiptEntry>();

    public AutoArchiveJob() {
        super(IConfigService.Module.moduleImport);
    }

    @Override
    public void execute() throws Exception {
        int age;
        Date now = new Date();
        for (BordereauEntry bordereauEntry : IndexUtil.readBordereauIndex().getEntryList()) {
            age = DateUtil.getAge(DateUtil.toDate(bordereauEntry.getCreationDate()), now);
            if (age < 30) continue;
            this.bordereaux.add(bordereauEntry);
        }
        for (ReceiptEntry receiptEntry : IndexUtil.readReceiptIndex().getEntryList()) {
            age = DateUtil.getAge(DateUtil.toDate(receiptEntry.getDate()), now);
            if (age < 30 || receiptEntry.getStar().getValue().booleanValue()) continue;
            this.receipts.add(receiptEntry);
        }
    }

    @Override
    public void done() {
        if (this.bordereaux.isEmpty() && this.receipts.isEmpty()) {
            return;
        }
        AutoArchiveDialog dialog = new AutoArchiveDialog(30, this.bordereaux.size(), this.receipts.size());
        dialog.setVisible(true);
        boolean result = dialog.getResult();
        if (!result) {
            return;
        }
        Services.get(IBackendService.class).put(new ArchiveMultipleBordereauxJob(this.bordereaux));
        Services.get(IBackendService.class).put(new ArchiveMultipleReceiptsJob(new HashSet<ReceiptEntry>(this.receipts)));
    }

    @Override
    public String getMessage() {
        return "Automatische Archivierung";
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, new String[0]);
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

