/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauIndex;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.IBordereauIndexUpdater;
import ch.transsoft.edec.service.index.bordereau.IBordereauService;

public class BordereauArchiveUpdate
implements IBordereauIndexUpdater {
    private int year;
    private BordereauIndex index;
    private final BordereauEntry indexEntry;

    public BordereauArchiveUpdate(BordereauEntry indexEntry) {
        this.indexEntry = indexEntry;
        this.year = indexEntry.getYear();
    }

    @Override
    public void notifyChange() {
        Services.get(IBordereauService.class).archiveChanged(this.year, this.index);
    }

    @Override
    public void saveOrUpdateIndex() throws Exception {
        this.index = IndexUtil.readBordereauArchive(this.year);
        this.index.updateIndexEntry(this.indexEntry);
        IndexUtil.writeBordereauArchive(this.year, this.index);
    }

    @Override
    public void deleteEntry() throws Exception {
        this.index = IndexUtil.readBordereauArchive(this.year);
        this.index.removeIndexEntry(this.indexEntry);
        IndexUtil.writeBordereauArchive(this.year, this.index);
    }
}

