/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.evv.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;

public class ExportBordereauJob
extends BackendJobBase {
    private static final String BORDEREAU = "Bordereau";
    private final BordereauEntry indexEntry;
    private final File targetFolder;

    public ExportBordereauJob(BordereauEntry indexEntry, File targetFolder) {
        super(IConfigService.Module.moduleImport);
        Check.assertNotNull(indexEntry);
        Check.assertNotNull(targetFolder);
        this.indexEntry = indexEntry;
        this.targetFolder = targetFolder;
    }

    @Override
    public void done() {
    }

    @Override
    public void execute() throws Exception {
        BordereauInfo bordereau = this.readBordereauInfo(this.indexEntry);
        File target = new File(this.targetFolder, bordereau.getBordereauNumberStr());
        target.mkdirs();
        FileUtil.copy(bordereau.getData().asInputStream(), new File(target, "Bordereau.xml"));
        FileUtil.copy(bordereau.getValidationProtocol().asInputStream(), new File(target, "Bordereau Signature Check.txt"));
        PdfWriter.createBordereau(bordereau.getData().asInputStream(), new FileOutputStream(new File(target, "Bordereau.pdf")));
    }

    @Override
    public String getMessage() {
        return Services.getText(1441);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(644));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

