/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.e_dec.xml.schema.edecbordereauresponse.v1.BordereauDetailsType;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauFetchInfo;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.model.evvimport.bordereau.ReceiptDesc;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.BordereauIndexUpdate;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.FetchBordereauErrorHandler;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.IBordereauIndexUpdater;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.ezv.bordereau.BordereauResponse;
import ch.transsoft.edec.service.ezv.evv.sigcheck.DocumentValidator;
import ch.transsoft.edec.service.ezv.evv.sigcheck.ValidatorResult;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.io.ByteArrayInputStream;

public class FetchBordereauJob
extends BackendJobBase {
    private final FetchBordereauErrorHandler errorHandler;
    private final String spediteurNumber;
    private final OperatingMode mode;
    private final IEZVService.BordereauListEntry entry;
    private volatile IBordereauIndexUpdater indexUpdater;

    public FetchBordereauJob(String spediteurNumber, OperatingMode mode, IEZVService.BordereauListEntry entry, boolean silent) {
        super(IConfigService.Module.moduleImport);
        this.spediteurNumber = spediteurNumber;
        this.mode = mode;
        this.entry = entry;
        this.errorHandler = new FetchBordereauErrorHandler(silent);
    }

    @Override
    public void done() {
        this.indexUpdater.notifyChange();
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    public void execute() throws Exception {
        BordereauResponse response = Services.get(IEZVService.class).getBordereau(this.mode, this.spediteurNumber, this.entry);
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        BordereauInfo info = this.createInfo(response);
        this.saveBordereauInfo(info);
        this.indexUpdater = new BordereauIndexUpdate(info.createBordereauEntry());
        this.indexUpdater.saveOrUpdateIndex();
        BordereauFetchInfo fetchInfo = this.readBordereauFetchInfo();
        fetchInfo.updateLastFetchDate(info.getAccountNumber().getStringValue(), info.getCreationDate());
        this.saveBordereauFetchInfo(fetchInfo);
    }

    private BordereauInfo createInfo(BordereauResponse response) {
        BordereauInfo result = NodeFactory.create(BordereauInfo.class);
        result.getBordereauNumber().setValue(response.getResponse().getDocumentInformation().getDocumentNumber());
        result.getCreationDate().setValue(DateUtil.toEdecDateString(response.getResponse().getDocumentInformation().getDocumentDate()), true);
        Check.assertTrue(result.getCreationDate().isInitialized(), "DocumentDate not initialized for Bordereau " + result.getBordereauNumberStr());
        result.getAccountNumber().setValue(response.getResponse().getAccount().getAccountNumber().longValue());
        result.getAccountName().setValue(response.getResponse().getAccount().getAccountName());
        result.getTotalNumberOfDocs().setValue(response.getResponse().getSummary().getTotals().getNumberOfDocuments().longValue());
        result.getTotalAmount().setValue(response.getResponse().getSummary().getTotals().getAmount().doubleValue());
        result.getZNumberOfDocs().setValue(response.getResponse().getSummary().getDutyAndAdditionalTaxes().getNumberOfDocuments().longValue());
        result.getZAmount().setValue(response.getResponse().getSummary().getDutyAndAdditionalTaxes().getAmount().doubleValue());
        result.getMNumberOfDocs().setValue(response.getResponse().getSummary().getVAT().getNumberOfDocuments().longValue());
        result.getMAmount().setValue(response.getResponse().getSummary().getVAT().getAmount().doubleValue());
        for (BordereauDetailsType.CustomsOffice current : response.getResponse().getDetails().getCustomsOffice()) {
            for (BordereauDetailsType.CustomsOffice.Detail detail : current.getDetail()) {
                result.getReceiptDescs().add(this.createReceiptDesc(detail));
            }
        }
        result.getData().setValue(response.getSoapMessage(), true);
        ValidatorResult validationResult = DocumentValidator.validate(new ByteArrayInputStream(response.getSoapMessage()), "Bordereau " + String.valueOf(result.getBordereauNumber()));
        if (validationResult.isValid()) {
            result.getState().setValue(ReceiptDocument.State.DOC_VALID.getValueAsLong());
        } else {
            result.getState().setValue(ReceiptDocument.State.DOC_INVALID.getValueAsLong());
        }
        result.getValidationProtocol().setValue(validationResult.getProtocol());
        return result;
    }

    private ReceiptDesc createReceiptDesc(BordereauDetailsType.CustomsOffice.Detail detail) {
        ReceiptDesc result = NodeFactory.create(ReceiptDesc.class);
        result.getCustomsReferenceNumber().setValue(detail.getCustomsReference());
        result.getVersion().setValue(detail.getCustomsDeclarationVersion().longValue());
        result.getType().setValue(ReceiptDocumentType.getReceiptDocumentType(detail.getDocumentType()));
        return result;
    }

    @Override
    public String getMessage() {
        return Services.getText(1430) + " " + this.entry.getBordereauNumberStr();
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public boolean locksActions() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.errorHandler.handleError(e2);
    }
}

