/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauIndex;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.index.bordereau.IBordereauService;

public class ReadBordereauArchiveJob
extends BackendJobBase {
    private final int year;
    private volatile BordereauIndex archivePart;

    public ReadBordereauArchiveJob(int year) {
        super(IConfigService.Module.moduleImport);
        this.year = year;
    }

    @Override
    public void done() {
        Services.get(IBordereauService.class).archiveChanged(this.year, this.archivePart);
    }

    @Override
    public void execute() throws Exception {
        this.archivePart = IndexUtil.readBordereauArchive(this.year);
    }

    @Override
    public String getMessage() {
        return Services.getText(1420);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.format(864, Services.getText(102) + " -> " + Services.getText(871)));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

