/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauIndex;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.IBordereauHandler;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.index.bordereau.IBordereauService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecreateBordereauIndexJob
extends BackendJobBase {
    private volatile List<String> errors = new ArrayList<String>();
    private volatile BordereauIndex index;
    private volatile Map<Integer, BordereauIndex> archive = new HashMap<Integer, BordereauIndex>();

    public RecreateBordereauIndexJob() {
        super(IConfigService.Module.moduleImport);
    }

    @Override
    public void done() {
        Services.get(IBordereauService.class).clearIndices();
        Services.get(IBordereauService.class).indexChanged(this.index);
        for (Integer year : this.archive.keySet()) {
            Services.get(IBordereauService.class).archiveChanged(year, this.archive.get(year));
        }
        if (this.errors.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        int errorCounter = 0;
        for (String error : this.errors) {
            if (++errorCounter > 10) break;
            message.append(error);
            message.append("\n");
        }
        Services.get(ILoggingService.class).logAndReport(Services.getText(877), message.toString());
    }

    @Override
    public void execute() throws Exception {
        List<File> result = FileUtil.recursiveDelete(IndexUtil.getBordereauIndexDir(false));
        if (!result.isEmpty()) {
            Check.fail(Services.getText(868) + " " + String.valueOf(result));
        }
        if (!(result = FileUtil.recursiveDelete(IndexUtil.getBordereauArchiveDir(false))).isEmpty()) {
            Check.fail(Services.getText(869) + " " + String.valueOf(result));
        }
        this.index = NodeFactory.create(BordereauIndex.class);
        this.readBordereaus();
        IndexUtil.writeBordereauIndex(this.index);
        for (Integer year : this.archive.keySet()) {
            IndexUtil.writeBordereauArchive(year, this.archive.get(year));
        }
    }

    private void readBordereaus() {
        SendingUtil.forAllBordereaus(new IBordereauHandler(){

            @Override
            public void handleGZ(File path, int yearPart) {
                try {
                    BordereauInfo info = FileUtil.readGZipFile(path, BordereauInfo.class);
                    RecreateBordereauIndexJob.this.handleBordereau(info, yearPart);
                }
                catch (Exception e2) {
                    RecreateBordereauIndexJob.this.errors.add(e2.getMessage() + " in " + String.valueOf(path));
                }
            }

            @Override
            public void handleXML(File path, int yearPart) {
                try {
                    BordereauInfo info = FileUtil.readXMLFile(path, BordereauInfo.class);
                    RecreateBordereauIndexJob.this.handleBordereau(info, yearPart);
                }
                catch (Exception e2) {
                    RecreateBordereauIndexJob.this.errors.add(e2.getMessage() + " in " + String.valueOf(path));
                }
            }
        });
    }

    private void handleBordereau(BordereauInfo info, int year) {
        if (info.getArchive().getValue().booleanValue()) {
            this.getArchivePart(info, year).getEntryList().add(info.createBordereauEntry());
        } else {
            this.index.getEntryList().add(info.createBordereauEntry());
        }
    }

    private BordereauIndex getArchivePart(BordereauInfo info, int year) {
        BordereauIndex part = this.archive.get(year);
        if (part == null) {
            part = NodeFactory.create(BordereauIndex.class);
            this.archive.put(year, part);
        }
        return part;
    }

    @Override
    public String getMessage() {
        return Services.getText(871);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(872));
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

