/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.evv.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class ShowBordereauAsPdfJob
extends BackendJobBase {
    private final BordereauEntry entry;
    private BordereauInfo bordereauInfo;

    public ShowBordereauAsPdfJob(BordereauEntry entry) {
        super(IConfigService.Module.moduleImport);
        this.entry = entry;
    }

    @Override
    public void done() {
        if (this.bordereauInfo == null) {
            return;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.bordereauInfo.getData().getByteArray());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PdfWriter.createBordereau(bis, bos);
            DocumentUtil.showPdf(bos.toByteArray(), "Bordereau");
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logAndReport(e2, "Failed to show receipt");
        }
    }

    @Override
    public void execute() throws Exception {
        this.bordereauInfo = this.readBordereauInfo(this.entry);
    }

    @Override
    public String getMessage() {
        return Services.getText(1471);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, "Error reading receipt");
    }

    @Override
    public boolean locksActions() {
        return false;
    }

    @Override
    public boolean skipAfterShutdown() {
        return true;
    }

    @Override
    public boolean showWaitCursor() {
        return true;
    }
}

