/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.BordereauArchiveUpdate;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.BordereauIndexUpdate;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.IBordereauIndexUpdater;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.Check;

public class UnarchiveBordereauToBordereauListJob
extends BackendJobBase {
    private volatile IBordereauIndexUpdater bordereauIndexUpdater;
    private volatile IBordereauIndexUpdater archiveUpdater;
    private final BordereauEntry indexEntry;

    public UnarchiveBordereauToBordereauListJob(BordereauEntry indexEntry) {
        super(IConfigService.Module.moduleImport);
        this.indexEntry = indexEntry;
        Check.assertNotNull(indexEntry);
    }

    @Override
    public void done() {
        this.bordereauIndexUpdater.notifyChange();
        this.archiveUpdater.notifyChange();
    }

    @Override
    public String getMessage() {
        return Services.getText(1443);
    }

    @Override
    public void execute() throws Exception {
        this.archiveUpdater = new BordereauArchiveUpdate(this.indexEntry);
        this.archiveUpdater.deleteEntry();
        this.bordereauIndexUpdater = new BordereauIndexUpdate(this.indexEntry);
        this.bordereauIndexUpdater.saveOrUpdateIndex();
        BordereauInfo bordereau = this.readBordereauInfo(this.indexEntry);
        bordereau.getArchive().setValue(false);
        this.saveBordereauInfo(bordereau);
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(861));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

