/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.IReceiptIndexUpdater;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ReceiptArchiveUpdate;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ReceiptIndexUpdate;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.ezv.evv.sigcheck.DocumentValidator;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.util.Check;

public abstract class AbstractReceiptAddingJob
extends BackendJobBase {
    private IReceiptIndexUpdater indexUpdater;
    private final byte[] data;
    private final ReceiptDocumentType documentType;

    public AbstractReceiptAddingJob(byte[] data, ReceiptDocumentType documentType) {
        super(IConfigService.Module.moduleImport);
        this.data = data;
        this.documentType = documentType;
    }

    public ReceiptDocumentType getDocumentType() {
        return this.documentType;
    }

    protected void notifyChange() {
        this.indexUpdater.notifyChange();
    }

    protected void addReceiptToImportSending(ImportSendingKey key, ReceiptEntry entry, ImportSending.ReceiptSource receiptSource) throws Exception {
        if (entry != null) {
            Check.assertEquals(key.getCustomsReferenceNumber(), entry.getCustomsReferenceNumberStr());
            this.addToExistingImportSending(entry);
        } else {
            this.createNewImportSending(key, receiptSource);
        }
    }

    private void createNewImportSending(ImportSendingKey key, ImportSending.ReceiptSource receiptSource) throws Exception {
        ImportSendingList importSendingList = this.readOrCreateImportSendingList(this.getDocumentDate());
        ImportSending importSending = importSendingList.getImportSending(key);
        if (importSending == null) {
            importSending = this.createImportSending(key, receiptSource);
        }
        this.applyDataToImportSending(importSending);
        importSendingList.add(importSending);
        this.saveImportSendingList(importSendingList);
        this.indexUpdater = new ReceiptIndexUpdate(importSending.createReceiptEntry());
        this.indexUpdater.saveOrUpdateIndex();
        this.reportNewlyCreatedImportSending(importSending);
    }

    private ImportSendingList readOrCreateImportSendingList(EdecDateNode date) {
        try {
            return this.readImportSendingList(date);
        }
        catch (Exception e2) {
            ImportSendingList result = NodeFactory.create(ImportSendingList.class);
            result.getDate().apply(date);
            return result;
        }
    }

    protected abstract void reportNewlyCreatedImportSending(ImportSending var1);

    private void addToExistingImportSending(ReceiptEntry entry) throws Exception {
        ImportSendingList importSendingList = this.readImportSendingList(entry.getDate());
        ImportSending importSending = importSendingList.getImportSending(entry.getKey());
        if (importSending == null) {
            DialogUtil.showErrorDialog("Can not store ImportSending", "Index out of sync with filesystem. Please recreate index with Configuration -> recreate index.");
            return;
        }
        this.applyDataToImportSending(importSending);
        this.saveImportSendingList(importSendingList);
        entry = importSending.createReceiptEntry();
        this.indexUpdater = importSending.getArchive().getValue() != false ? new ReceiptArchiveUpdate(entry) : new ReceiptIndexUpdate(entry);
        this.indexUpdater.saveOrUpdateIndex();
    }

    private void applyDataToImportSending(ImportSending importSending) {
        ReceiptDocument receiptDocument = importSending.getReceiptDocument(this.documentType);
        receiptDocument.getData().setValue(this.data);
        String inputName = String.valueOf((Object)this.documentType) + " " + importSending.getCustomsReferenceNumber().getValue();
        DocumentValidator.addValidationInfo(this.data, inputName, receiptDocument);
        this.setDeclarationType(importSending.getDeclarationType());
    }

    protected abstract void setDeclarationType(IntegralNode var1);

    private ImportSending createImportSending(ImportSendingKey key, ImportSending.ReceiptSource receiptSource) {
        ImportSending result = NodeFactory.create(ImportSending.class);
        result.getCustomsReferenceNumber().setValue(key.getCustomsReferenceNumber());
        result.getBordereauNumber().setValue(this.getBordereauNumberStr());
        result.getDate().apply(this.getDocumentDate(), true);
        result.getReceiptSource().setValue(receiptSource);
        return result;
    }

    protected abstract EdecDateNode getDocumentDate();

    protected abstract String getBordereauNumberStr();
}

