/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.AbstractReceiptAddingJob;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.DocumentUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public class AddReceiptFromFileJob
extends AbstractReceiptAddingJob {
    private final Map<ImportSendingKey, ReceiptEntry> receiptEntries = new HashMap<ImportSendingKey, ReceiptEntry>();
    private final Document doc;

    public AddReceiptFromFileJob(Document doc, byte[] data, ReceiptDocumentType documentType) {
        super(data, documentType);
        this.doc = doc;
    }

    @Override
    protected void setDeclarationType(IntegralNode declarationType) {
        DocumentUtil.setInteger(declarationType, this.doc, "declarationType");
    }

    @Override
    protected EdecDateNode getDocumentDate() {
        return DocumentUtil.getDocumentDate(this.doc);
    }

    @Override
    protected String getBordereauNumberStr() {
        return DocumentUtil.getString(this.doc, "bordereauNumber");
    }

    @Override
    public void done() {
        super.notifyChange();
    }

    @Override
    public void execute() throws Exception {
        this.readReceiptEntries();
        ImportSendingKey key = new ImportSendingKey(DocumentUtil.getString(this.doc, "documentNumber"), DocumentUtil.getString(this.doc, "documentDate"));
        ReceiptEntry entry = this.receiptEntries.get(key);
        this.addReceiptToImportSending(key, entry, ImportSending.ReceiptSource.file);
    }

    private void readReceiptEntries() {
        this.addReceiptEntries(IndexUtil.readReceiptIndex());
        int documentDate = DocumentUtil.getDocumentDate(this.doc).getYear();
        int numberOfYears = DateUtil.getCurrentYear() - documentDate + 2;
        for (int year : DateUtil.getYearsBackFrom(new Date(), numberOfYears)) {
            this.addReceiptEntries(IndexUtil.readReceiptArchive(year));
        }
    }

    private void addReceiptEntries(ReceiptIndex index) {
        for (ReceiptEntry current : index.getEntryList()) {
            this.receiptEntries.put(current.getKey(), current);
        }
    }

    @Override
    public String getMessage() {
        return Services.getText(1433);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, "Failed to create Import-Sendings");
    }

    @Override
    public boolean locksActions() {
        return true;
    }

    @Override
    protected void reportNewlyCreatedImportSending(ImportSending importSending) {
    }
}

