/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.infra.node.BinaryNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.evv.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ExportImportSendingJob
extends BackendJobBase {
    private final List<ReceiptEntry> entries;
    private final File targetFolder;

    public ExportImportSendingJob(List<ReceiptEntry> entries, File targetFolder) {
        super(IConfigService.Module.moduleImport);
        Check.assertNotNull(entries);
        Check.assertNotNull(targetFolder);
        this.entries = entries;
        this.targetFolder = targetFolder;
    }

    @Override
    public void done() {
    }

    @Override
    public void execute() throws Exception {
        for (ReceiptEntry receiptEntry : this.entries) {
            ImportSending sending = this.readImportSending(receiptEntry);
            File target = new File(this.targetFolder, sending.getCustomsReferenceNumber().getValue());
            target.mkdirs();
            this.saveReceipt(target, sending.getVvz(), "vvz");
            this.saveReceipt(target, sending.getVvm(), "vvm");
            this.saveReceipt(target, sending.getRbz(), "rbz");
            this.saveReceipt(target, sending.getRbm(), "rbm");
        }
    }

    private void saveReceipt(File target, ReceiptDocument doc, String receiptType) throws Exception {
        if (!doc.hasDocumentOrError()) {
            return;
        }
        byte[] data = this.fixNewLine(doc.getData().getByteArray());
        FileUtil.copy((InputStream)new ByteArrayInputStream(data), new File(target, receiptType + ".xml"));
        if (!doc.hasError()) {
            FileUtil.copy(doc.getValidationProtocol().asInputStream(), new File(target, receiptType + " Signature Check.txt"));
            PdfWriter.createReceipt(doc.getData().asInputStream(), (OutputStream)new FileOutputStream(new File(target, receiptType + ".pdf")));
        }
    }

    private byte[] fixNewLine(byte[] data) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        if (!new String(data, BinaryNode.DEFAULT_CHARSET).startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) {
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes(BinaryNode.DEFAULT_CHARSET));
        }
        int last = 0;
        while (in.available() > 0) {
            int current = in.read();
            if (last != 10 || current != 10) {
                out.write(current);
            }
            last = current;
        }
        return out.toByteArray();
    }

    @Override
    public String getMessage() {
        return Services.getText(1427);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(643));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

