/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.IImportSendingListHandler;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.IImportColDesc;
import ch.transsoft.edec.ui.dialog.export.evvimport.pm.ImpXmlDomWrapper;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.DocumentUtil;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;

public class ExtractEvvImportJob
extends BackendJobBase
implements IImportSendingListHandler {
    private final Date from;
    private final Date to;
    private final String delimiterStr;
    private final boolean showHeader;
    private final File file;
    private final List<ImportSending> importSendings = new ArrayList<ImportSending>();
    private final List<IImportColDesc> headers;
    private final List<IImportColDesc> items;

    public ExtractEvvImportJob(List<IImportColDesc> headers, List<IImportColDesc> items, Date from, Date to, String delimiterStr, boolean showHeader, File file) {
        super(IConfigService.Module.moduleImport);
        this.headers = headers;
        this.items = items;
        this.from = from;
        this.to = DateUtil.getEndOfDay(to);
        this.delimiterStr = delimiterStr;
        this.showHeader = showHeader;
        this.file = file;
    }

    @Override
    public void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        this.addAllImportSendingsToMap();
        ArrayList<ImportSending> list = this.getSortedImportSendingList();
        ArrayList<String> result = new ArrayList<String>();
        if (this.showHeader) {
            result.add(this.getHeaderLine());
        }
        for (ImportSending current : list) {
            this.addLines(current, result);
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), Charset.forName("ISO-8859-1")));
            for (String line : result) {
                out.write(line + "\n");
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(out);
    }

    public String getHeaderLine() {
        StringBuilder result = new StringBuilder();
        this.addHeaders(this.headers, result);
        this.addHeaders(this.items, result);
        return result.toString();
    }

    private void addHeaders(List<IImportColDesc> descs, StringBuilder result) {
        for (IImportColDesc desc : descs) {
            if (!desc.isEnabled()) continue;
            if (result.length() != 0) {
                result.append(this.delimiterStr);
            }
            result.append(desc.getCaption());
        }
    }

    private void addLines(ImportSending sending, List<String> result) throws Exception {
        Document rbz;
        Document vvm = sending.getVvm().hasDocument() ? DocumentUtil.readXmlDoc(sending.getVvm().getData().asInputStream()) : null;
        Document vvz = sending.getVvz().hasDocument() ? DocumentUtil.readXmlDoc(sending.getVvz().getData().asInputStream()) : null;
        Document rbm = sending.getRbm().hasDocument() ? DocumentUtil.readXmlDoc(sending.getRbm().getData().asInputStream()) : null;
        Document document = rbz = sending.getRbz().hasDocument() ? DocumentUtil.readXmlDoc(sending.getRbz().getData().asInputStream()) : null;
        if (vvm == null && vvz == null && rbm == null && rbz == null) {
            return;
        }
        ImpXmlDomWrapper wrapper = new ImpXmlDomWrapper(sending, vvm, vvz, rbm, rbz, this.headers, this.items, this.delimiterStr);
        wrapper.addLines(result);
    }

    private void addAllImportSendingsToMap() {
        File root = Services.get(IConfigService.class).getReceiptDocsDir(true);
        for (int year = DateUtil.getYear(this.from); year <= DateUtil.getYear(this.to); ++year) {
            File yearPath = new File(root, Integer.toString(year));
            if (!yearPath.isDirectory()) continue;
            SendingUtil.handleImportSendingListsOfOneYear(this, yearPath, year);
        }
    }

    private ArrayList<ImportSending> getSortedImportSendingList() {
        ArrayList<ImportSending> list = new ArrayList<ImportSending>(this.importSendings);
        Collections.sort(list, new Comparator<ImportSending>(){

            @Override
            public int compare(ImportSending o1, ImportSending o2) {
                if (o1.getDate().isSame(o2.getDate())) {
                    return 0;
                }
                return o1.getDate().before(o2.getDate()) ? -1 : 1;
            }
        });
        return list;
    }

    @Override
    public String getMessage() {
        return Services.getText(4750);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, new String[0]);
    }

    @Override
    public boolean locksActions() {
        return true;
    }

    @Override
    public void handleGZ(File path, int yearPart) {
        try {
            ImportSendingList list = FileUtil.readGZipFile(path, ImportSendingList.class);
            this.handleImportSendingList(list, yearPart);
        }
        catch (Exception e2) {
            this.log(e2, e2.getMessage() + " in " + String.valueOf(path));
        }
    }

    @Override
    public void handleXML(File path, int yearPart) {
        try {
            ImportSendingList list = FileUtil.readXMLFile(path, ImportSendingList.class);
            this.handleImportSendingList(list, yearPart);
        }
        catch (Exception e2) {
            this.log(e2, e2.getMessage() + " in " + String.valueOf(path));
        }
    }

    private void handleImportSendingList(ImportSendingList list, int year) {
        for (ImportSending importSending : list.getImportSendings()) {
            this.handle(importSending, year);
        }
    }

    private void handle(ImportSending importSending, int year) {
        Date date = DateUtil.toDate(importSending.getDate());
        if (date.equals(this.from) || date.equals(this.to) || date.after(this.from) && date.before(this.to)) {
            Check.assertTrue(importSending.getCustomsReferenceNumber().isInitialized(), "importSending has no customsNumber: " + String.valueOf(date));
            String key = importSending.getCustomsReferenceNumber().getValue();
            this.importSendings.add(importSending);
        }
    }
}

