/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.e_dec.services.edecreceiptservice.v3.ReceiptRequestFault;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.ReceiptRequestResponse;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.TaxationDecisionImportType;
import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.SafeTransactionReporter;
import ch.transsoft.edec.service.backend.jobs.evv.FetchEvvJobErrorHandler;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.IReceiptIndexUpdater;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ReceiptArchiveUpdate;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ReceiptFetchDescription;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ReceiptIndexUpdate;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.ezv.evv.EvvErrorHandler;
import ch.transsoft.edec.service.ezv.evv.EvvResponse;
import ch.transsoft.edec.service.ezv.evv.sigcheck.DocumentValidator;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.ErrorUtil;

public class FetchReceiptJob
extends BackendJobBase {
    private final FetchEvvJobErrorHandler errorHandler;
    private final String spediteurNumber;
    private final String guid;
    private final OperatingMode mode;
    private final ReceiptFetchDescription desc;
    private volatile IReceiptIndexUpdater indexUpdater;

    public FetchReceiptJob(String guid, String spediteurNumber, OperatingMode mode, ReceiptFetchDescription desc, boolean silent) {
        super(IConfigService.Module.moduleImport);
        this.guid = guid;
        this.spediteurNumber = spediteurNumber;
        this.mode = mode;
        this.desc = desc;
        this.errorHandler = new FetchEvvJobErrorHandler(silent);
    }

    @Override
    public void done() {
        this.indexUpdater.notifyChange();
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    public void execute() throws Exception {
        try {
            EvvResponse receipt = Services.get(IEZVService.class).getEvv(this.mode, this.spediteurNumber, this.desc.getCustomsReferenceNumberStr(), this.desc.getCustomsDeclarationVersion(), this.desc.getReceiptDocumentType());
            if (receipt.getSoapMessage() == null) {
                throw new IllegalStateException("Received no document from customs");
            }
            Check.assertTrue(receipt.getSoapMessage().length > 0, "Received empty document from customs");
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.saveReceipt(receipt);
        }
        catch (ReceiptRequestFault error) {
            this.saveError(ErrorUtil.getErrorString(EvvErrorHandler.createErrorList(error)));
        }
        catch (Exception error) {
            this.saveError(error.getMessage());
        }
    }

    private void saveError(String errorString) throws Exception {
        EdecDateNode date = this.desc.getBordereauCreationDate();
        ImportSendingList importSendingList = this.readImportSendingList(date);
        ImportSending importSending = importSendingList.getImportSending(this.desc.getKey());
        Check.assertNotNull(importSending, "ImportSending not found: " + String.valueOf(date) + " / " + this.desc.getCustomsReferenceNumberStr());
        ReceiptDocument document = importSending.getReceiptDocument(this.desc.getReceiptDocumentType());
        document.getData().setStringValue(errorString);
        document.getState().setValue(ReceiptDocument.State.DOC_ERROR.getValueAsLong());
        this.saveImportSendingList(importSendingList);
        this.indexUpdater = this.createIndexUpdater(importSending);
        this.indexUpdater.saveOrUpdateIndex();
    }

    private IReceiptIndexUpdater createIndexUpdater(ImportSending importSending) {
        return importSending.getArchive().getValue() != false ? new ReceiptArchiveUpdate(importSending.createReceiptEntry()) : new ReceiptIndexUpdate(importSending.createReceiptEntry());
    }

    private void saveReceipt(EvvResponse receipt) throws Exception {
        EdecDateNode date = this.desc.getBordereauCreationDate();
        ImportSendingList importSendingList = this.readImportSendingList(date);
        ImportSending importSending = importSendingList.getImportSending(this.desc.getKey());
        Check.assertNotNull(importSending, "ImportSending not found: " + String.valueOf(date) + " / " + this.desc.getCustomsReferenceNumberStr());
        this.setData(receipt.getResponse(), importSending, this.desc.getReceiptDocumentType());
        ReceiptDocument document = importSending.getReceiptDocument(this.desc.getReceiptDocumentType());
        document.getData().setValue(receipt.getSoapMessage(), true);
        this.updateManuallyDownloadedOrImportedSending(importSending);
        String inputName = String.valueOf((Object)this.desc.getReceiptDocumentType()) + " " + importSending.getCustomsReferenceNumber().getValue();
        DocumentValidator.addValidationInfo(receipt.getSoapMessage(), inputName, document);
        this.saveImportSendingList(importSendingList);
        this.indexUpdater = this.createIndexUpdater(importSending);
        this.indexUpdater.saveOrUpdateIndex();
        SafeTransactionReporter.saveReportTransactionImport(this.guid, this.desc.getCustomsReferenceNumberStr(), this.mode == OperatingMode.production);
    }

    private void updateManuallyDownloadedOrImportedSending(ImportSending importSending) {
        if (importSending.getReceiptSource().getValue() == ImportSending.ReceiptSource.bordereau) {
            return;
        }
        importSending.getBordereauNumber().setValue(this.desc.getBordereauNumberStr());
        importSending.getReceiptSource().setValue(ImportSending.ReceiptSource.bordereau);
    }

    private void setData(ReceiptRequestResponse response, ImportSending importSending, ReceiptDocumentType type) {
        switch (type) {
            case vvz: {
                this.setData(importSending, response.getTaxationDecisionCustomsDuties());
                break;
            }
            case vvm: {
                this.setData(importSending, response.getTaxationDecisionVAT());
                break;
            }
            case rbz: 
            case rbm: {
                break;
            }
            default: {
                Check.fail("Unexpected ReceiptType " + String.valueOf((Object)type));
            }
        }
    }

    private void setData(ImportSending importSending, TaxationDecisionImportType taxation) {
        importSending.getDeclarationType().setValue(taxation.getDeclarationType().longValue());
    }

    @Override
    public String getMessage() {
        return Services.getText(1432) + " " + this.desc.getReceiptDesc().getCustomsReferenceNumber().getValue();
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public boolean locksActions() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.errorHandler.handleError(e2);
    }

    @Override
    public boolean skipAfterShutdown() {
        return true;
    }
}

