/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauInfo;
import ch.transsoft.edec.model.evvimport.bordereau.ReceiptDesc;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.util.Check;
import java.math.BigInteger;

public class ReceiptFetchDescription {
    private final ReceiptDesc receiptDesc;
    private final BordereauInfo bordereauInfo;

    public ReceiptFetchDescription(ReceiptDesc receiptDesc, BordereauInfo bordereauInfo) {
        Check.assertNotNull(receiptDesc);
        Check.assertNotNull(bordereauInfo);
        this.receiptDesc = receiptDesc;
        this.bordereauInfo = bordereauInfo;
    }

    public ReceiptDocumentType getReceiptDocumentType() {
        return this.receiptDesc.getType().getValue();
    }

    public String getCustomsReferenceNumberStr() {
        return this.receiptDesc.getCustomsReferenceNumber().getValue();
    }

    public ReceiptDesc getReceiptDesc() {
        return this.receiptDesc;
    }

    public EdecDateNode getBordereauCreationDate() {
        return this.bordereauInfo.getCreationDate();
    }

    public ImportSendingKey getKey() {
        return new ImportSendingKey(this.getCustomsReferenceNumberStr(), this.bordereauInfo.getDocumentDate());
    }

    public String getBordereauNumberStr() {
        return this.bordereauInfo.getBordereauNumberStr();
    }

    public BigInteger getCustomsDeclarationVersion() {
        if (!this.receiptDesc.getVersion().isInitialized()) {
            return BigInteger.ZERO;
        }
        return BigInteger.valueOf(this.receiptDesc.getVersion().getValue());
    }
}

