/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.IImportSendingListHandler;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.GuiService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.index.receipt.IReceiptService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecreateReceiptIndexJob
extends BackendJobBase {
    private final List<String> errors = new ArrayList<String>();
    private volatile ReceiptIndex index;
    private final Map<Integer, ReceiptIndex> archive = new HashMap<Integer, ReceiptIndex>();

    public RecreateReceiptIndexJob() {
        super(IConfigService.Module.moduleImport);
    }

    @Override
    public void done() {
        Services.get(IReceiptService.class).clearIndices();
        Services.get(IReceiptService.class).indexChanged(this.index);
        for (Integer year : this.archive.keySet()) {
            Services.get(IReceiptService.class).archiveChanged(year, this.archive.get(year));
        }
        Services.get(IGuiService.class).moduleChanged();
        Services.get(IGuiService.class).selectImportTab(GuiService.ImportTab.receipts, null);
        if (this.errors.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        int errorCounter = 0;
        for (String error : this.errors) {
            if (++errorCounter > 10) break;
            message.append(error);
            message.append("\n");
            message.append("\n");
        }
        Services.get(ILoggingService.class).logAndReport(Services.getText(877), message.toString());
    }

    @Override
    public void execute() throws Exception {
        List<File> result = FileUtil.recursiveDelete(IndexUtil.getReceiptIndexDir(false));
        if (!result.isEmpty()) {
            Check.fail(Services.getText(868) + " " + String.valueOf(result));
        }
        if (!(result = FileUtil.recursiveDelete(IndexUtil.getReceiptArchiveDir(false))).isEmpty()) {
            Check.fail(Services.getText(869) + " " + String.valueOf(result));
        }
        this.index = NodeFactory.create(ReceiptIndex.class);
        this.readReceipts();
        IndexUtil.writeReceiptIndex(this.index);
        for (Integer year : this.archive.keySet()) {
            IndexUtil.writeReceiptArchive(year, this.archive.get(year));
        }
    }

    private void readReceipts() {
        SendingUtil.forAllImportSendingLists(new IImportSendingListHandler(){

            @Override
            public void handleGZ(File path, int yearPart) {
                try {
                    ImportSendingList list = FileUtil.readGZipFile(path, ImportSendingList.class);
                    RecreateReceiptIndexJob.this.handleImportSendingList(list, yearPart);
                }
                catch (Exception e2) {
                    RecreateReceiptIndexJob.this.errors.add(e2.getMessage() + " in\n" + String.valueOf(path));
                }
            }

            @Override
            public void handleXML(File path, int yearPart) {
                try {
                    ImportSendingList list = FileUtil.readXMLFile(path, ImportSendingList.class);
                    RecreateReceiptIndexJob.this.handleImportSendingList(list, yearPart);
                }
                catch (Exception e2) {
                    RecreateReceiptIndexJob.this.errors.add(e2.getMessage() + " in " + String.valueOf(path));
                }
            }
        });
    }

    private void handleImportSendingList(ImportSendingList list, int year) {
        for (ImportSending importSending : list.getImportSendings()) {
            this.handle(importSending, year);
        }
    }

    private void handle(ImportSending importSending, int year) {
        if (importSending.getArchive().getValue().booleanValue()) {
            this.getArchivePart(year).getEntryList().add(importSending.createReceiptEntry());
        } else {
            this.index.getEntryList().add(importSending.createReceiptEntry());
        }
    }

    private ReceiptIndex getArchivePart(int year) {
        ReceiptIndex part = this.archive.get(year);
        if (part == null) {
            part = NodeFactory.create(ReceiptIndex.class);
            this.archive.put(year, part);
        }
        return part;
    }

    @Override
    public String getMessage() {
        return Services.getText(871);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(872));
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

