/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.smtp.ISmtpService;
import ch.transsoft.edec.service.webservices.mail.CarrierMail;
import ch.transsoft.edec.ui.dialog.mail.model.AttachmentEntry;
import ch.transsoft.edec.ui.dialog.mail.model.IAttachmentBody;
import jakarta.xml.ws.WebServiceException;
import java.net.ConnectException;

public final class SendMailToImporteurViaSmtpJob
extends BackendJobBase {
    private final ListNode<AttachmentEntry> attachments;
    private final CarrierMail mail;
    private final ReceiptEntry entry;

    public SendMailToImporteurViaSmtpJob(ReceiptEntry entry, CarrierMail mail, ListNode<AttachmentEntry> attachments) {
        super(IConfigService.Module.moduleImport);
        this.entry = entry;
        this.mail = mail;
        this.attachments = attachments;
    }

    @Override
    public void done() {
    }

    @Override
    public String getMessage() {
        return Services.getText(885);
    }

    @Override
    public void execute() throws Exception {
        ImportSending sending = this.readImportSending(this.entry);
        for (AttachmentEntry attachment : this.attachments) {
            this.addAttachment(attachment, sending);
        }
        Services.get(ISmtpService.class).send(this.mail, this.attachments, sending);
    }

    private void addAttachment(AttachmentEntry attachment, ImportSending sending) throws Exception {
        CarrierMail.Attachment result = new CarrierMail.Attachment();
        IAttachmentBody body = attachment.getBody();
        result.setFileName(body.getFileName());
        result.setMime(body.getMimeType());
        result.setData(body.getData(sending));
        this.mail.getAttachments().add(result);
    }

    @Override
    public void handleError(Throwable e2) {
        if (e2 instanceof WebServiceException && e2.getCause() instanceof ConnectException) {
            this.log(e2.getCause(), Services.getText(622) + "\n" + Services.getText(623));
            return;
        }
        this.log(e2, Services.getText(886));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

