/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingList;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.IReceiptIndexUpdater;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ReceiptArchiveUpdate;
import ch.transsoft.edec.service.backend.jobs.evvimport.receipt.ReceiptIndexUpdate;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.Check;

public class UpdateStarJob
extends BackendJobBase {
    private volatile IReceiptIndexUpdater indexUpdater;
    private final ReceiptEntry entry;

    public UpdateStarJob(ReceiptEntry entry) {
        super(IConfigService.Module.moduleImport);
        this.entry = entry;
    }

    @Override
    public void done() {
        this.indexUpdater.notifyChange();
    }

    @Override
    public void execute() throws Exception {
        ImportSendingList importSendingList = this.readImportSendingList(this.entry.getDate());
        ImportSending importSending = importSendingList.getImportSending(this.entry.getKey());
        Check.assertNotNull(importSending, "ImportSending not found: " + this.entry.getDate().getValue() + " / " + this.entry.getCustomsReferenceNumberStr());
        importSending.getStar().setValue(this.entry.getStar().getValue() == false);
        this.saveImportSendingList(importSendingList);
        this.indexUpdater = importSending.getArchive().getValue() != false ? new ReceiptArchiveUpdate(importSending.createReceiptEntry()) : new ReceiptIndexUpdate(importSending.createReceiptEntry());
        this.indexUpdater.saveOrUpdateIndex();
    }

    @Override
    public String getMessage() {
        return Services.getText(1446);
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public boolean locksActions() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, new String[0]);
    }

    @Override
    public boolean skipAfterShutdown() {
        return false;
    }
}

