/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.imp;

import ch.transsoft.edec.model.infra.LoggingContext;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.XMLReader;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.IBackendJob;
import ch.transsoft.edec.service.backend.jobs.imp.TextReader;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.pm.imp.SendingInfo;
import ch.transsoft.edec.ui.pm.imp.table.ImportTableModel;
import ch.transsoft.edec.util.Check;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ReadImportsJob
extends BackendJobBase
implements IBackendJob {
    private final ImportTableModel importTableModel;
    private final File importDir;
    private final List<SendingInfo> result = new ArrayList<SendingInfo>();
    private final boolean force;

    public ReadImportsJob(File importDir, ImportTableModel importTableModel, boolean force) {
        super(IConfigService.Module.moduleExport);
        this.force = force;
        Check.assertNotNull(importDir);
        Check.assertNotNull(importTableModel);
        this.importDir = importDir;
        this.importTableModel = importTableModel;
    }

    @Override
    public void done() {
        this.importTableModel.setSendingList(this.result, this.force);
    }

    @Override
    public void execute() throws Exception {
        if (this.importDir.listFiles() == null) {
            return;
        }
        for (File current : this.importDir.listFiles()) {
            if (current.getName().endsWith(".imported")) continue;
            this.readImport(current);
        }
    }

    private void readImport(File file) {
        try {
            LoggingContext context = new LoggingContext();
            Sending readSending = this.readSending(context, file);
            if (readSending == null) {
                return;
            }
            this.result.add(new SendingInfo(file, readSending, context));
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logSilent(e2, "Error when importing " + String.valueOf(file));
            this.result.add(new SendingInfo(file, this.createErrorSending(), e2));
        }
    }

    private Sending readSending(LoggingContext context, File file) throws Exception {
        if (file.getName().toLowerCase().endsWith(".xml")) {
            return this.readXml(context, file);
        }
        if (file.getName().toLowerCase().endsWith(".edec")) {
            return this.readAscii(context, file);
        }
        return null;
    }

    private Sending readAscii(LoggingContext context, File file) throws IOException {
        Sending sending = NodeFactory.create(Sending.class);
        return new TextReader(sending).read(context, file);
    }

    private Sending readXml(LoggingContext context, File file) throws Exception {
        XMLReader reader = new XMLReader();
        return reader.read(this.openFile(file), Sending.class, context);
    }

    private Sending createErrorSending() {
        return NodeFactory.create(Sending.class);
    }

    private InputStream openFile(File current) throws FileNotFoundException {
        return new FileInputStream(current);
    }

    @Override
    public String getMessage() {
        return Services.getText(830);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(831));
    }

    @Override
    public boolean locksActions() {
        return false;
    }

    @Override
    public boolean isInterruptible() {
        return false;
    }
}

