/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.manip;

import ch.transsoft.edec.model.index.Index;
import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.backend.jobs.manip.IIndexUpdater;
import ch.transsoft.edec.service.index.sending.IIndexService;

public class ArchiveUpdate
implements IIndexUpdater {
    private int year;
    private Index index;
    private final IndexEntry indexEntry;

    public ArchiveUpdate(IndexEntry indexEntry) {
        this.indexEntry = indexEntry;
        this.year = indexEntry.getYear();
    }

    @Override
    public void notifyChange() {
        Services.get(IIndexService.class).archiveChanged(this.year, this.index);
    }

    @Override
    public void saveOrUpdateIndex() throws Exception {
        this.index = IndexUtil.readArchive(this.year);
        this.index.updateIndexEntry(this.indexEntry);
        IndexUtil.writeArchive(this.year, this.index);
    }

    @Override
    public void deleteEntry() throws Exception {
        this.index = IndexUtil.readArchive(this.year);
        this.index.removeIndexEntry(this.indexEntry);
        IndexUtil.writeArchive(this.year, this.index);
    }
}

