/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.manip;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.manip.ArchiveUpdate;
import ch.transsoft.edec.service.backend.jobs.manip.CompoundManip;
import ch.transsoft.edec.service.backend.jobs.manip.IIndexUpdater;
import ch.transsoft.edec.service.backend.jobs.manip.ISendingManip;
import ch.transsoft.edec.service.backend.jobs.manip.IndexUpdate;
import ch.transsoft.edec.service.backend.jobs.manip.NullIndexUpdat;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.util.Check;

public abstract class SendingManipJobBase
extends BackendJobBase {
    private volatile Sending backgroundSending;
    private Sending storedSending;
    private volatile String sendingId;
    private volatile IIndexUpdater indexUpdater = new NullIndexUpdat();
    private volatile CompoundManip manip = new CompoundManip();

    public SendingManipJobBase(Sending currentSending) {
        super(IConfigService.Module.moduleExport);
        this.backgroundSending = currentSending.getCopy((ModelNode)null);
        Check.assertTrue(currentSending.hasSendingId(), "Sending must have a sendingId");
        this.sendingId = currentSending.getSendingId();
    }

    public SendingManipJobBase(String sendingId) {
        super(IConfigService.Module.moduleExport);
        Check.assertNotNull(sendingId);
        this.sendingId = sendingId;
        if (this.isCurrentSending(sendingId)) {
            this.backgroundSending = this.getCurrentSending().getCopy((ModelNode)null);
        }
    }

    @Override
    public void done() {
        if (this.isJobWasCanceled()) {
            return;
        }
        this.indexUpdater.notifyChange();
        if (!this.isCurrentSending(this.sendingId)) {
            return;
        }
        this.manip.execute(this.getCurrentSending());
        this.getCurrentSending().clearPendingChanges();
    }

    protected boolean isJobWasCanceled() {
        return this.manip.isEmpty();
    }

    @Override
    public abstract String getMessage();

    @Override
    public final void execute() throws Exception {
        this.storedSending = this.readSending(this.sendingId);
        if (this.backgroundSending == null) {
            this.backgroundSending = this.storedSending;
        }
        if (this.cancelExecute(this.backgroundSending)) {
            return;
        }
        this.manip.add(this.doExecute(this.backgroundSending));
        this.manip.add(sending -> sending.getVersion().setValue(this.storedSending.getVersion().getValue() + 1L));
        this.manip.execute(this.backgroundSending);
        this.saveSending(this.backgroundSending);
        this.updateIndex();
        this.postProcessing();
    }

    protected void postProcessing() {
    }

    protected abstract ISendingManip doExecute(Sending var1) throws Exception;

    protected abstract boolean cancelExecute(Sending var1) throws Exception;

    private void updateIndex() throws Exception {
        IndexEntry indexEntry = this.backgroundSending.getIndexEntry();
        this.indexUpdater = this.backgroundSending.getArchive().getValue() != false ? new ArchiveUpdate(indexEntry) : new IndexUpdate(indexEntry);
        this.indexUpdater.saveOrUpdateIndex();
    }

    @Override
    public final void handleError(Throwable e2) {
        if (this.isCurrentSending(this.sendingId)) {
            this.handleErrorForCurrentSending(this.getCurrentSending(), e2);
        } else {
            this.handleErrorForSavedSending(this.sendingId, e2);
        }
    }

    protected abstract void handleErrorForCurrentSending(Sending var1, Throwable var2);

    protected abstract void handleErrorForSavedSending(String var1, Throwable var2);

    @Override
    public boolean needsLocking() {
        return true;
    }

    protected void setSendingId(String sendingId) {
        this.sendingId = sendingId;
    }

    @Override
    public boolean locksActions() {
        return true;
    }

    public String getSendingId() {
        return this.sendingId;
    }

    protected boolean showDialogIfSendingIsInConflict() throws Exception {
        if (!this.isSendingInConflict()) {
            return false;
        }
        return DialogUtil.showOverwriteDialogt(null, Services.getText(881), Services.getText(882)) != 0;
    }

    protected boolean isSendingInConflict() {
        return !this.backgroundSending.getVersion().isEquals(this.storedSending.getVersion());
    }
}

