/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.IndexUtil;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.index.receipt.IReceiptService;

public class ReadReceiptArchiveJob
extends BackendJobBase {
    private final int year;
    private volatile ReceiptIndex archivePart;

    public ReadReceiptArchiveJob(int year) {
        super(IConfigService.Module.moduleExport);
        this.year = year;
    }

    @Override
    public void done() {
        Services.get(IReceiptService.class).archiveChanged(this.year, this.archivePart);
    }

    @Override
    public void execute() throws Exception {
        this.archivePart = IndexUtil.readReceiptArchive(this.year);
    }

    @Override
    public String getMessage() {
        return Services.getText(1422);
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.format(864, Services.getText(102) + " -> " + Services.getText(871)));
    }

    @Override
    public boolean locksActions() {
        return false;
    }
}

