/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs.template;

import ch.transsoft.edec.model.infra.XMLWriter;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.util.Check;
import java.io.File;

public class SaveTemplateJob
extends BackendJobBase {
    private final File file;
    private final Sending copy;
    private final Sending original;

    public SaveTemplateJob(File file, Sending sending, boolean saveSendingAsTemplate) {
        super(IConfigService.Module.moduleExport);
        this.file = file;
        this.original = sending;
        this.copy = sending.getCopy((ModelNode)null);
        this.copy.cleanForSaveTemplate();
        if (saveSendingAsTemplate) {
            this.copy.cleanForSavingSendingAsTempate();
        }
    }

    @Override
    public void done() {
        Services.get(IGuiService.class).refreshTemplateModel();
        this.original.clearPendingChanges();
    }

    @Override
    public String getMessage() {
        return Services.getText(850) + " " + this.file.getName();
    }

    @Override
    public void execute() throws Exception {
        try {
            XMLWriter xmlWriter = new XMLWriter();
            xmlWriter.write(this.file, this.copy, false);
        }
        catch (Exception ex) {
            Check.fail(ex);
        }
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(851) + " " + String.valueOf(this.file));
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

