/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv;

import ch.e_dec.services.edecbordereauservice.v1.EdecBordereauPortType;
import ch.e_dec.services.edecreceiptservice.v3.EdecReceiptPortType;
import ch.e_dec.services.edecservice.v4.EdecPortType;
import ch.e_dec.services.edecservice.v4.EdecService;
import ch.e_dec.xml.schema.edec.v4.GoodsDeclarations;
import ch.e_dec.xml.schema.edecbordereaurequest.v1.BordereauRequest;
import ch.e_dec.xml.schema.edecbordereauresponse.v1.BordereauListType;
import ch.e_dec.xml.schema.edecbordereauresponse.v1.BordereauRequestResponse;
import ch.e_dec.xml.schema.edecreceiptrequest.v3.ReceiptRequestType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.DocumentTypeList;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.ReceiptListType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.ReceiptRequestResponse;
import ch.e_dec.xml.schema.edecresponse.v4.GoodsDeclarationAcceptanceType;
import ch.e_dec.xml.schema.edecresponse.v4.GoodsDeclarationsResponse;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.State;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.certificate.ICertificateService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.ezv.LoggingHandler;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.ezv.aza.AzaResponse;
import ch.transsoft.edec.service.ezv.aza.AzaTranslator;
import ch.transsoft.edec.service.ezv.bordereau.BordereauResponse;
import ch.transsoft.edec.service.ezv.bordereau.BordereauTranslator;
import ch.transsoft.edec.service.ezv.evv.EvvResponse;
import ch.transsoft.edec.service.ezv.evv.EvvTranslator;
import ch.transsoft.edec.service.ezv.evv.ResponseFetchHandler;
import ch.transsoft.edec.service.ezv.evv.Role;
import ch.transsoft.edec.service.ezv.evv.SecurityHandler;
import ch.transsoft.edec.util.Base64;
import ch.transsoft.edec.util.Check;
import jakarta.xml.ws.Binding;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.handler.Handler;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class EZVService
implements IEZVService {
    @Override
    public synchronized AzaResponse sendAza(Sending sending) throws Exception {
        EdecPortType edecService = this.getAzaService(sending);
        Holder<GoodsDeclarationsResponse> response = new Holder<GoodsDeclarationsResponse>();
        Holder<byte[]> eDecExportAL = new Holder<byte[]>();
        GoodsDeclarations gd = new AzaTranslator(sending).createGoodsDeclaration();
        edecService.goodsDeclarations(gd, response, this.holder(), this.holder(), this.holder(), this.holder(), this.holder(), this.holder(), eDecExportAL);
        AzaResponse result = new AzaResponse();
        if (!((GoodsDeclarationsResponse)response.value).getGoodsDeclarationStatus().isEmpty()) {
            result.setStatus(((GoodsDeclarationsResponse)response.value).getGoodsDeclarationStatus().get(0));
        }
        if (!((GoodsDeclarationsResponse)response.value).getGoodsDeclarationAcceptance().isEmpty()) {
            GoodsDeclarationAcceptanceType acceptance = ((GoodsDeclarationsResponse)response.value).getGoodsDeclarationAcceptance().get(0);
            byte[] al = this.decode(eDecExportAL);
            result.setAl(al, acceptance);
        }
        return result;
    }

    private Holder<byte[]> holder() {
        return new Holder<byte[]>();
    }

    private byte[] decode(Holder<byte[]> decExportAL) {
        byte[] result = Base64.decode((byte[])decExportAL.value);
        if (result == null) {
            result = (byte[])decExportAL.value;
        }
        return result;
    }

    private EdecPortType getAzaService(Sending sending) {
        this.updateCertificate();
        URL wsdlURL = this.getAzaWsdl(sending);
        String namespace = "http://www.e-dec.ch/services/EdecService/v4/";
        String serviceName = "EdecService";
        QName serviceQN = new QName(namespace, serviceName);
        Service service = EdecService.create(wsdlURL, serviceQN);
        EdecPortType result = service.getPort(EdecPortType.class);
        this.addHandlers((BindingProvider)((Object)result), new LoggingHandler());
        return result;
    }

    @Override
    public synchronized EvvResponse getEvv(OperatingMode operatingMode, String uid, String customsDeclarationNumber, BigInteger customsDeclarationVersion, ReceiptDocumentType docType) throws Exception {
        EdecReceiptPortType service = this.getEvvService(operatingMode);
        ResponseFetchHandler messageFetcher = new ResponseFetchHandler();
        this.addHandlers((BindingProvider)((Object)service), messageFetcher);
        ReceiptRequestType request = EvvTranslator.createReceipt(uid, customsDeclarationNumber, customsDeclarationVersion, docType);
        ReceiptRequestResponse response = service.receiptRequest(request);
        return new EvvResponse(messageFetcher.getSoapMessage(), response);
    }

    @Override
    public synchronized void getEvvListExport(OperatingMode mode, String uid, Date startDate, Date endDate, boolean unreadOnly, Role role, Set<IEZVService.EvvExportListEntry> result) throws Exception {
        this.updateCertificate();
        EdecReceiptPortType service = this.getEvvService(mode);
        ReceiptRequestType request = EvvTranslator.createReceiptListExport(uid, startDate, endDate, role);
        ReceiptRequestResponse answer = service.receiptRequest(request);
        for (ReceiptListType.ReceiptInformation info : answer.getReceiptList().getReceiptInformation()) {
            DocumentTypeList type = info.getDocumentType();
            Check.assertTrue(type == DocumentTypeList.TAXATION_DECISION_EXPORT, "Unexpected type for export: " + String.valueOf((Object)type));
            String customsDeclarationNumber = info.getCustomsDeclarationNumber();
            BigInteger customsDeclarationVersion = info.getCustomsDeclarationVersion();
            Date date = info.getDocumentDate().toGregorianCalendar().getTime();
            String consignee = info.getConsigneeName();
            result.add(new IEZVService.EvvExportListEntry(customsDeclarationNumber, customsDeclarationVersion, type, date, consignee));
        }
    }

    @Override
    public synchronized void getEvvListImport(OperatingMode mode, String importID, Date startDate, Date endDate, String zazAccount, List<IEZVService.EvvImportListEntry> result) throws Exception {
        Check.assertNotNull(zazAccount);
        this.updateCertificate();
        EdecReceiptPortType service = this.getEvvService(mode);
        ReceiptRequestType request = EvvTranslator.createReceiptListImport(importID, startDate, endDate, Role.Kontoinhaber, zazAccount);
        ReceiptRequestResponse answer = service.receiptRequest(request);
        for (ReceiptListType.ReceiptInformation info : answer.getReceiptList().getReceiptInformation()) {
            DocumentTypeList type = info.getDocumentType();
            if (type == DocumentTypeList.TAXATION_DECISION_EXPORT) continue;
            String customsDeclarationNumber = info.getCustomsDeclarationNumber();
            BigInteger customsDeclarationVersion = info.getCustomsDeclarationVersion();
            XMLGregorianCalendar date = info.getDocumentDate();
            String consignee = info.getConsigneeName();
            BigInteger account = info.getAccountNumber();
            result.add(new IEZVService.EvvImportListEntry(customsDeclarationNumber, customsDeclarationVersion, type, date, consignee, account.toString()));
        }
    }

    @Override
    public synchronized void getBordereauList(OperatingMode mode, String spediteurNumber, String accountNumber, Date startDate, Date endDate, boolean unreadOnly, List<IEZVService.BordereauListEntry> result) throws Exception {
        EdecBordereauPortType service = this.getBordereauService(mode);
        BordereauRequest request = BordereauTranslator.createBordereauList(spediteurNumber, accountNumber, startDate, endDate, unreadOnly);
        BordereauRequestResponse answer = service.bordereauRequest(request);
        for (BordereauListType.BordereauInformation info : answer.getBordereauList().getBordereauInformation()) {
            BigInteger bordereauNumber = info.getBordereauNumber();
            BigInteger processingCenterNumber = info.getProcessingCenterNumber();
            XMLGregorianCalendar creationDate = info.getCreationDate();
            result.add(new IEZVService.BordereauListEntry(bordereauNumber, processingCenterNumber, creationDate));
        }
    }

    @Override
    public synchronized BordereauResponse getBordereau(OperatingMode mode, String spediteurNumber, IEZVService.BordereauListEntry entry) throws Exception {
        EdecBordereauPortType service = this.getBordereauService(mode);
        ResponseFetchHandler messageFetcher = new ResponseFetchHandler();
        this.addHandlers((BindingProvider)((Object)service), messageFetcher);
        BordereauRequest request = BordereauTranslator.createBordereau(spediteurNumber, entry);
        BordereauRequestResponse response = service.bordereauRequest(request);
        return new BordereauResponse(messageFetcher.getSoapMessage(), response.getBordereau());
    }

    private EdecReceiptPortType getEvvService(OperatingMode operatingMode) {
        this.updateCertificate();
        URL wsdlURL = this.getEvvWsdl(operatingMode);
        String namespace = "http://www.e-dec.ch/services/EdecReceiptService/v3/";
        String serviceName = "EdecReceiptService";
        QName serviceQN = new QName(namespace, serviceName);
        Service service = EdecService.create(wsdlURL, serviceQN);
        EdecReceiptPortType result = service.getPort(EdecReceiptPortType.class);
        this.addHandlers((BindingProvider)((Object)result), new SecurityHandler(), new LoggingHandler());
        return result;
    }

    private EdecBordereauPortType getBordereauService(OperatingMode operatingMode) {
        this.updateCertificate();
        URL wsdlURL = this.getBordereauWsdl(operatingMode);
        String namespace = "http://www.e-dec.ch/services/EdecBordereauService/v1/";
        String serviceName = "EdecBordereauService";
        QName serviceQN = new QName(namespace, serviceName);
        Service service = EdecService.create(wsdlURL, serviceQN);
        EdecBordereauPortType result = service.getPort(EdecBordereauPortType.class);
        this.addHandlers((BindingProvider)((Object)result), new SecurityHandler(), new LoggingHandler());
        return result;
    }

    private void addHandlers(BindingProvider bindingProvider, Handler ... handlers) {
        Binding binding = bindingProvider.getBinding();
        List<Handler> handlerList = binding.getHandlerChain();
        if (handlerList == null) {
            handlerList = new ArrayList<Handler>();
        }
        handlerList.addAll(Arrays.asList(handlers));
        binding.setHandlerChain(handlerList);
    }

    private void updateCertificate() {
        Services.get(ICertificateService.class).updateCertificate();
    }

    @Override
    public URL getAzaWsdl(Sending sending) {
        State state = sending.getState();
        if (state.getOperatingMode() == OperatingMode.undefined) {
            return this.createAzaWsdl(this.isTestSystem());
        }
        boolean testMode = state.getOperatingMode() == OperatingMode.test;
        return this.createAzaWsdl(testMode);
    }

    private boolean isTestSystem() {
        return Services.get(IConfigService.class).isTestSystem();
    }

    private URL createAzaWsdl(boolean testMode) {
        return testMode ? this.getClass().getResource("wsdl/aza_4_0_test.xml") : this.getClass().getResource("wsdl/aza_4_0.xml");
    }

    private URL createEvvWsdl(boolean testMode) {
        return testMode ? this.getClass().getResource("wsdl/evv_test_3_0.xml") : this.getClass().getResource("wsdl/evv_3_0.xml");
    }

    private URL createBordereauWsdl(boolean testMode) {
        return testMode ? this.getClass().getResource("wsdl/bordereau_test.xml") : this.getClass().getResource("wsdl/bordereau.xml");
    }

    @Override
    public String getAzaVersion() {
        return "4.0";
    }

    @Override
    public String getBordereauVersion() {
        return "0.1";
    }

    @Override
    public String getEvvVersion() {
        return "3.0";
    }

    @Override
    public URL getEvvWsdl(OperatingMode operatingMode) {
        return this.createEvvWsdl(operatingMode == OperatingMode.test);
    }

    @Override
    public URL getBordereauWsdl(OperatingMode operatingMode) {
        return this.createBordereauWsdl(operatingMode == OperatingMode.test);
    }
}

