/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv;

import ch.e_dec.xml.schema.edecreceiptresponse.v3.DocumentTypeList;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.sending.OperatingMode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.ezv.aza.AzaResponse;
import ch.transsoft.edec.service.ezv.bordereau.BordereauResponse;
import ch.transsoft.edec.service.ezv.evv.EvvResponse;
import ch.transsoft.edec.service.ezv.evv.Role;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.math.BigInteger;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;

public interface IEZVService {
    public static final int MAX_EVV_DATE_RANGE = 10;

    public AzaResponse sendAza(Sending var1) throws Exception;

    public EvvResponse getEvv(OperatingMode var1, String var2, String var3, BigInteger var4, ReceiptDocumentType var5) throws Exception;

    public void getEvvListExport(OperatingMode var1, String var2, Date var3, Date var4, boolean var5, Role var6, Set<EvvExportListEntry> var7) throws Exception;

    public void getEvvListImport(OperatingMode var1, String var2, Date var3, Date var4, String var5, List<EvvImportListEntry> var6) throws Exception;

    public void getBordereauList(OperatingMode var1, String var2, String var3, Date var4, Date var5, boolean var6, List<BordereauListEntry> var7) throws Exception;

    public BordereauResponse getBordereau(OperatingMode var1, String var2, BordereauListEntry var3) throws Exception;

    public URL getAzaWsdl(Sending var1);

    public String getAzaVersion();

    public URL getEvvWsdl(OperatingMode var1);

    public String getEvvVersion();

    public URL getBordereauWsdl(OperatingMode var1);

    public String getBordereauVersion();

    public static class BordereauListEntry {
        public final BigInteger bordereauNumber;
        public final BigInteger processingCenterNumber;
        public final XMLGregorianCalendar creationDate;

        public BordereauListEntry(BigInteger bordereauNumber, BigInteger processingCenterNumber, XMLGregorianCalendar creationDate) {
            this.bordereauNumber = bordereauNumber;
            this.processingCenterNumber = processingCenterNumber;
            this.creationDate = creationDate;
        }

        public String getBordereauNumberStr() {
            return this.bordereauNumber.toString();
        }
    }

    public static class EvvImportListEntry {
        private final String customsDeclarationNumber;
        private final BigInteger customsDeclarationVersion;
        private final ImportSendingKey importSendingKey;
        private final DocumentTypeList type;
        private final Date date;
        private final String consignee;
        private final String account;

        public EvvImportListEntry(String customsDeclarationNumber, BigInteger customsDeclarationVersion, DocumentTypeList type, XMLGregorianCalendar date, String consignee, String account) {
            Check.assertNotNull(customsDeclarationNumber);
            Check.assertNotNull(customsDeclarationVersion);
            this.customsDeclarationNumber = customsDeclarationNumber;
            this.customsDeclarationVersion = customsDeclarationVersion;
            this.type = type;
            this.date = date.toGregorianCalendar().getTime();
            this.consignee = consignee;
            this.account = account;
            this.importSendingKey = new ImportSendingKey(customsDeclarationNumber, DateUtil.toEdecDateString(date));
        }

        public String toString() {
            return this.customsDeclarationNumber;
        }

        public String getCustomsDeclarationNumber() {
            return this.customsDeclarationNumber;
        }

        public DocumentTypeList getType() {
            return this.type;
        }

        public Date getDate() {
            return this.date;
        }

        public String getConsignee() {
            return this.consignee;
        }

        public String getAccount() {
            return this.account;
        }

        public ReceiptDocumentType getReceiptDocumentType() {
            return ReceiptDocumentType.getReceiptDocumentType(this.getType());
        }

        public BigInteger getCustomsDeclarationVersion() {
            return this.customsDeclarationVersion;
        }

        public ImportSendingKey getKey() {
            return this.importSendingKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EvvImportListEntry that = (EvvImportListEntry)o;
            return this.importSendingKey.equals(that.importSendingKey);
        }

        public int hashCode() {
            return this.importSendingKey.hashCode();
        }
    }

    public static class EvvExportListEntry {
        private final String customsDeclarationNumber;
        private final BigInteger customsDeclarationVersion;
        private final DocumentTypeList type;
        private final Date date;
        private final String consignee;

        public EvvExportListEntry(String customsDeclarationNumber, BigInteger customsDeclarationVersion, DocumentTypeList type, Date date, String consignee) {
            Check.assertNotNull(customsDeclarationNumber);
            Check.assertNotNull(customsDeclarationVersion);
            this.customsDeclarationNumber = customsDeclarationNumber;
            this.customsDeclarationVersion = customsDeclarationVersion;
            this.type = type;
            this.date = date;
            this.consignee = consignee;
        }

        public String toString() {
            return this.customsDeclarationNumber;
        }

        public String getCustomsDeclarationNumber() {
            return this.customsDeclarationNumber;
        }

        public DocumentTypeList getType() {
            return this.type;
        }

        public Date getDate() {
            return this.date;
        }

        public String getConsignee() {
            return this.consignee;
        }

        public ReceiptDocumentType getReceiptDocumentType() {
            return ReceiptDocumentType.getReceiptDocumentType(this.getType());
        }

        public BigInteger getCustomsDeclarationVersion() {
            return this.customsDeclarationVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EvvExportListEntry that = (EvvExportListEntry)o;
            if (!this.customsDeclarationNumber.equals(that.customsDeclarationNumber)) {
                return false;
            }
            return this.customsDeclarationVersion.equals(that.customsDeclarationVersion);
        }

        public int hashCode() {
            int result = this.customsDeclarationNumber.hashCode();
            result = 31 * result + this.customsDeclarationVersion.hashCode();
            return result;
        }
    }
}

