/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.aza;

import ch.e_dec.xml.schema.edec.v4.BusinessType;
import ch.e_dec.xml.schema.edec.v4.ContainerType;
import ch.e_dec.xml.schema.edec.v4.DeclarantType;
import ch.e_dec.xml.schema.edec.v4.GoodsDeclarationType;
import ch.e_dec.xml.schema.edec.v4.GoodsDeclarations;
import ch.e_dec.xml.schema.edec.v4.GoodsItemType;
import ch.e_dec.xml.schema.edec.v4.NonCustomsLawType;
import ch.e_dec.xml.schema.edec.v4.NotificationType;
import ch.e_dec.xml.schema.edec.v4.PackagingType;
import ch.e_dec.xml.schema.edec.v4.PermitType;
import ch.e_dec.xml.schema.edec.v4.ProducedDocumentType;
import ch.e_dec.xml.schema.edec.v4.RefundType;
import ch.e_dec.xml.schema.edec.v4.RepairAndRefinementType;
import ch.e_dec.xml.schema.edec.v4.SensibleGoodsType;
import ch.e_dec.xml.schema.edec.v4.SpecialMentionType;
import ch.e_dec.xml.schema.edec.v4.StatisticType;
import ch.e_dec.xml.schema.edec.v4.TransportMeansType;
import ch.transsoft.edec.model.infra.node.DateNode;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.model.sending.goodsdeclaration.BondedWarehouse;
import ch.transsoft.edec.model.sending.goodsdeclaration.Business;
import ch.transsoft.edec.model.sending.goodsdeclaration.Carrier;
import ch.transsoft.edec.model.sending.goodsdeclaration.Consignor;
import ch.transsoft.edec.model.sending.goodsdeclaration.Container;
import ch.transsoft.edec.model.sending.goodsdeclaration.Declarant;
import ch.transsoft.edec.model.sending.goodsdeclaration.GoodsDeclaration;
import ch.transsoft.edec.model.sending.goodsdeclaration.SpecialMentionHeader;
import ch.transsoft.edec.model.sending.goodsdeclaration.TransportMeans;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Confirmation;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItemDetail;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.NonCustomsLaw;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.NonCustomsLaws;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Notification;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Permit;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Permits;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.ProducedDocument;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.RepairAndRefinement;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.SensibleGoods;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.SpecialMention;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.masterdataezv.IMasterDataEZVService;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.util.UidUtil;
import java.math.BigInteger;
import java.util.List;

public class AzaTranslator {
    private final Sending sending;

    public AzaTranslator(Sending sending) {
        this.sending = sending;
    }

    public GoodsDeclarations createGoodsDeclaration() {
        GoodsDeclarations result = new GoodsDeclarations();
        result.setSchemaVersion(Services.get(IEZVService.class).getAzaVersion());
        result.getGoodsDeclaration().add(this.goodsDeclarationType(this.sending));
        return result;
    }

    private GoodsDeclarationType goodsDeclarationType(Sending sending) {
        GoodsDeclarationType result = new GoodsDeclarationType();
        GoodsDeclaration gd = sending.getGoodsDeclaration();
        result.setServiceType(gd.getServiceType().asBigInt());
        result.setTraderDeclarationNumber(gd.getTraderDeclarationNumber().getValue());
        if (gd.getTraderReference().isInitialized()) {
            result.setTraderReference(gd.getTraderReferenceFirst35Chars());
        }
        result.setClearanceLocation(gd.getClearanceLocation().asBigInt());
        result.setDeclarationTime(gd.getDeclarationTime().asBigInt());
        result.setDeclarationType(gd.getDeclarationType().asBigInt());
        result.setCorrectionCode(gd.getCorrectionCode().asBigInt());
        if (gd.getCorrectionReason().isInitialized()) {
            result.setCorrectionReason(gd.getCorrectionReason().asBigInt());
        }
        result.setLanguage(this.getDocumentLanguage());
        result.setDeliveryDestination(gd.getDeliveryDestination().asString());
        result.setTransferToTransitSystem(gd.getTransferToTransitSystem().asBigInt());
        if (gd.getCustomsOfficeNumber().isInitialized()) {
            result.setCustomsOfficeNumber(gd.getCustomsOfficeNumber().asString());
        }
        result.setTransportMeans(this.transportMeans(gd.getTransportMeans(), gd.getBondedWarehouse()));
        result.setTransportInContainer(this.inContainer(gd.getContainers()));
        this.addContainers(result, gd.getContainers());
        this.addSpecialMentionsHeader(result.getSpecialMention(), gd.getSpecialMentions());
        result.setConsignor(this.createConsignor(gd.getConsignor()));
        result.setConsignee(this.createConsignee(sending.getDeliveryAddress()));
        result.setDeclarant(this.declarant(gd.getDeclarant()));
        this.setCarrier(result, gd.getCarrier());
        result.setBusiness(this.business(gd.getBusiness(), gd.getConsignor()));
        this.addItems(result.getGoodsItem(), sending.getCustomsItemListIfPresent().getGoodsItems());
        this.addSecurity(result, sending);
        this.addBondedWarehouse(result, sending);
        return result;
    }

    private void addBondedWarehouse(GoodsDeclarationType result, Sending sending) {
        BondedWarehouse bondedWarehouse = sending.getGoodsDeclaration().getBondedWarehouse();
        if (!bondedWarehouse.isEnabled()) {
            return;
        }
        result.setBailor(this.createBailor(bondedWarehouse.getBailor()));
        result.setVendee(this.createVendee(bondedWarehouse.getVendee()));
        result.setWarehouseCoded(bondedWarehouse.getWarehouseCoded().asBigInt());
    }

    private void addSecurity(GoodsDeclarationType result, Sending sending) {
        if (Services.get(IMasterDataEZVService.class).isInSecurityZone(sending.getGoodsDeclaration().getDeliveryDestination().getValue())) {
            return;
        }
        result.setSecurity(BigInteger.ONE);
        result.setUniqueConsignmentReferenceNumber(sending.getTraderDeclarationNumber());
        result.setConsignorSecurity(this.createConsignorSecurity(sending.getGoodsDeclaration().getConsignor()));
        result.setConsigneeSecurity(this.createConsigneeSecurity(sending.getDeliveryAddress()));
    }

    private String getDocumentLanguage() {
        String language = Services.get(IConfigService.class).getOptionInfo().getDocumentLanguageInfo().getDocumentLanguage().getValue().getKey();
        if (language.equals("--")) {
            return Services.get(ITextService.class).getCurrentLanguage().name();
        }
        return language;
    }

    private void addItems(List<GoodsItemType> goodsItem, ListNode<GoodsItem> items) {
        GoodsItemType previousItem = null;
        for (GoodsItem current : items) {
            GoodsItemType result = this.goodsItemType(previousItem, current);
            goodsItem.add(result);
            previousItem = result;
        }
    }

    private GoodsItemType goodsItemType(GoodsItemType previousItem, GoodsItem item) {
        GoodsItemType result = new GoodsItemType();
        result.setTraderItemID(item.getGoodsData().getTraderItemID().getStringValue());
        result.setDescription(item.getEdecDescription());
        result.setCommodityCode(item.getGoodsData().getCommodityCode().getValue());
        result.setGrossMass(item.getGoodsData().getGrossMass().asBigDecimal());
        if (item.getGoodsData().getStatisticalCode().isInitialized()) {
            result.setStatisticalCode(item.getGoodsData().getStatisticalCode().asBigInt());
        }
        if (item.getGoodsData().getNetMass().isInitialized()) {
            result.setNetMass(item.getGoodsData().getNetMass().asBigDecimal());
        }
        result.setStatistic(this.statisticType(item.getGoodsData(), item.getRepairAndRefinement()));
        result.getPackaging().add(this.packagingType(previousItem, item.getGoodsData()));
        if (item.getGoodsData().getAdditionalUnit().isInitialized()) {
            result.setAdditionalUnit(item.getGoodsData().getAdditionalUnit().asBigDecimal());
        }
        this.addProducedDocuments(result.getProducedDocument(), item);
        this.addPermits(result, item.getPermits());
        this.addNotifications(result.getNotification(), item.getNotifications());
        this.addSpecialMentions(result.getSpecialMention(), item.getSpecialMentions());
        this.addSensibleGoods(result.getSensibleGoods(), item.getSensibleGoods());
        this.addRepairAndRefinement(result, item.getRepairAndRefinement());
        this.addRefund(result, item.getGoodsData());
        this.addNonCustomLaws(result, item.getNonCustomLaws());
        this.setConfirmation(result, item.getConfirmation());
        result.setGoodsItemDetails(this.createGoodsItemDetails(item.getGoodsItemDetail()));
        return result;
    }

    private GoodsItemType.GoodsItemDetails createGoodsItemDetails(ListNode<GoodsItemDetail> goodsItemDetailList) {
        if (goodsItemDetailList.isEmpty()) {
            return null;
        }
        GoodsItemType.GoodsItemDetails result = new GoodsItemType.GoodsItemDetails();
        this.addGoodsItemDetail(result.getGoodsItemDetail(), goodsItemDetailList);
        return result;
    }

    private void addGoodsItemDetail(List<GoodsItemType.GoodsItemDetails.GoodsItemDetail> list, ListNode<GoodsItemDetail> goodsItemDetailList) {
        for (GoodsItemDetail current : goodsItemDetailList) {
            list.add(this.createGoodsItemDetail(current));
        }
    }

    private GoodsItemType.GoodsItemDetails.GoodsItemDetail createGoodsItemDetail(GoodsItemDetail current) {
        GoodsItemType.GoodsItemDetails.GoodsItemDetail result = new GoodsItemType.GoodsItemDetails.GoodsItemDetail();
        result.setName(current.getName().asString());
        result.setValue(current.getValue().getValue());
        return result;
    }

    private void addNonCustomLaws(GoodsItemType result, NonCustomsLaws nonCustomLaws) {
        result.setNonCustomsLawObligation(nonCustomLaws.getNonCustomsLawObligation().asBigInt());
        for (NonCustomsLaw current : nonCustomLaws.getNonCustomsLawList()) {
            result.getNonCustomsLaw().add(this.createNonCustomsLawType(current));
        }
    }

    private NonCustomsLawType createNonCustomsLawType(NonCustomsLaw current) {
        NonCustomsLawType result = new NonCustomsLawType();
        result.setNonCustomsLawType(current.getNonCustomsLawType().asBigInt());
        return result;
    }

    private void setConfirmation(GoodsItemType result, Confirmation node) {
        result.setAdditionalUnitConfirmation(node.getAdditionalUnitConfirmation().asBigInt());
        result.setCommodityCodeConfirmation(BigInteger.ZERO);
        result.setNetMassConfirmation(node.getNetMassConfirmation().asBigInt());
        result.setGrossMassConfirmation(node.getGrossMassConfirmation().asBigInt());
        result.getStatistic().setStatisticalValueConfirmation(node.getStatisticalValueConfirmation().asBigInt());
    }

    private void addRefund(GoodsItemType result, GoodsData goodsData) {
        if (!goodsData.getRefundType().isInitialized() && !goodsData.getVOCQuantity().isInitialized()) {
            return;
        }
        result.setRefund(this.createRefundType(goodsData));
    }

    private RefundType createRefundType(GoodsData goodsData) {
        RefundType result = new RefundType();
        if (goodsData.getRefundType().isInitialized()) {
            result.setRefundType(goodsData.getRefundType().asBigInt());
        }
        if (goodsData.getVOCQuantity().isInitialized()) {
            result.setVOCQuantity(goodsData.getVOCQuantity().asBigDecimal());
        }
        return result;
    }

    private void addRepairAndRefinement(GoodsItemType result, RepairAndRefinement node) {
        if (!node.getDirection().isInitialized()) {
            return;
        }
        result.setRepairAndRefinement(this.createRepairAndRefinementType(node));
    }

    private RepairAndRefinementType createRepairAndRefinementType(RepairAndRefinement node) {
        RepairAndRefinementType result = new RepairAndRefinementType();
        if (node.getDirection().isInitialized()) {
            result.setDirection(node.getDirection().asBigInt());
        }
        if (node.getRefinementType().isInitialized()) {
            result.setRefinementType(node.getRefinementType().asBigInt());
        }
        if (node.getProcessType().isInitialized()) {
            result.setProcessType(node.getProcessType().asBigInt());
        }
        if (node.getBillingType().isInitialized()) {
            result.setBillingType(node.getBillingType().asBigInt());
        }
        if (node.getRepairReason().isInitialized()) {
            result.setRepairReason(node.getRepairReason().getValue());
        }
        return result;
    }

    private void addSpecialMentions(List<SpecialMentionType> specialMention, ListNode<SpecialMention> specialMentions) {
        for (SpecialMention current : specialMentions) {
            specialMention.add(this.createSpecialmentionType(current.getText().getValue()));
        }
    }

    private SpecialMentionType createSpecialmentionType(String text) {
        SpecialMentionType result = new SpecialMentionType();
        result.setText(text);
        return result;
    }

    private void addNotifications(List<NotificationType> notification, ListNode<Notification> notifications) {
        for (Notification current : notifications) {
            notification.add(this.createNotificationType(current));
        }
    }

    private NotificationType createNotificationType(Notification current) {
        NotificationType result = new NotificationType();
        result.setNotificationCode(current.getNotificationCode().getValue().getKey());
        return result;
    }

    private void addSensibleGoods(List<SensibleGoodsType> sensibleGoods, ListNode<SensibleGoods> sensibleGoodsList) {
        for (SensibleGoods current : sensibleGoodsList) {
            sensibleGoods.add(this.createSensibleGoodsType(current));
        }
    }

    private SensibleGoodsType createSensibleGoodsType(SensibleGoods current) {
        SensibleGoodsType result = new SensibleGoodsType();
        if (current.getType().isInitialized()) {
            result.setType(current.getType().asBigInt());
        }
        result.setWeight(current.getWeight().asBigDecimal());
        return result;
    }

    private void addPermits(GoodsItemType result, Permits permits) {
        result.setPermitObligation(permits.getPermitObligation().asBigInt());
        for (Permit current : permits.getPermitList()) {
            result.getPermit().add(this.createPermitType(current));
        }
    }

    private PermitType createPermitType(Permit permit) {
        PermitType result = new PermitType();
        result.setPermitNumber(permit.getPermitNumber().getValue());
        result.setPermitType(permit.getPermitType().asBigInt());
        result.setPermitAuthority(permit.getPermitAuthority().asBigInt());
        if (permit.getIssueDate().isInitialized()) {
            result.setIssueDate(permit.getIssueDate().asXmlGregorianCalendar());
        }
        if (permit.getAdditionalInformation().isInitialized()) {
            result.setAdditionalInformation(permit.getAdditionalInformation().getValue());
        }
        this.addPermitItemDetails(permit, result);
        return result;
    }

    private void addPermitItemDetails(Permit permit, PermitType result) {
        PermitType.PermitItemDetails.PermitItemDetail detail;
        if (!this.permitDetail1IsSet(permit) && !this.permitDetail2IsSet(permit)) {
            return;
        }
        PermitType.PermitItemDetails details = new PermitType.PermitItemDetails();
        if (this.permitDetail1IsSet(permit)) {
            detail = new PermitType.PermitItemDetails.PermitItemDetail();
            detail.setKey(permit.getPermitDetailKey().asBigInt());
            detail.setValue(permit.getPermitDetailValue().getValue());
            details.getPermitItemDetail().add(detail);
        }
        if (this.permitDetail2IsSet(permit)) {
            detail = new PermitType.PermitItemDetails.PermitItemDetail();
            detail.setKey(permit.getPermitDetailKey2().asBigInt());
            detail.setValue(permit.getPermitDetailValue2().getValue());
            details.getPermitItemDetail().add(detail);
        }
        result.setPermitItemDetails(details);
    }

    private boolean permitDetail1IsSet(Permit permit) {
        return permit.getPermitDetailKey().isInitialized() && permit.getPermitDetailValue().isInitialized();
    }

    private boolean permitDetail2IsSet(Permit permit) {
        return permit.getPermitDetailKey2().isInitialized() && permit.getPermitDetailValue2().isInitialized();
    }

    private void addProducedDocuments(List<ProducedDocumentType> producedDocument, GoodsItem item) {
        for (ProducedDocument current : item.getProducedDocuments()) {
            producedDocument.add(this.createProducedDocumentType(current));
        }
        this.addEUR1ProducedDocument(producedDocument, item);
    }

    private void addEUR1ProducedDocument(List<ProducedDocumentType> producedDocument, GoodsItem item) {
        if (!item.getGoodsData().getInEur().getValue().booleanValue()) {
            return;
        }
        if (!this.sending.getForms().getEur1().isEnabled()) {
            return;
        }
        StringNode eur1Number = this.sending.getForms().getEur1().getEur1Number();
        DateNode date = this.sending.getForms().getEur1().getDate();
        ProducedDocumentType result = new ProducedDocumentType();
        result.setDocumentType("954");
        result.setDocumentReferenceNumber(eur1Number.getValue());
        result.setIssueDate(date.asXmlGregorianCalendar());
        producedDocument.add(result);
    }

    private ProducedDocumentType createProducedDocumentType(ProducedDocument current) {
        ProducedDocumentType result = new ProducedDocumentType();
        result.setDocumentType(current.getDocumentType().asString());
        if (current.getDocumentReferenceNumber().isInitialized()) {
            result.setDocumentReferenceNumber(current.getDocumentReferenceNumber().getValue());
        }
        if (current.getIssueDate().isInitialized()) {
            result.setIssueDate(current.getIssueDate().asXmlGregorianCalendar());
        }
        if (current.getAdditionalInformation().isInitialized()) {
            result.setAdditionalInformation(current.getAdditionalInformation().getValue());
        }
        return result;
    }

    private PackagingType packagingType(GoodsItemType previousItem, GoodsData item) {
        PackagingType result = new PackagingType();
        if (item.isBeipack()) {
            PackagingType prev = previousItem.getPackaging().get(0);
            result.setQuantity(BigInteger.ZERO);
            result.setPackagingType(prev.getPackagingType());
            result.setPackagingReferenceNumber(prev.getPackagingReferenceNumber());
        } else {
            result.setPackagingType(item.getPackagingType().asString());
            if (item.getQuantity().isInitialized()) {
                result.setQuantity(item.getQuantity().asBigInt());
            }
            if (item.getPackagingReferenceNumber().isInitialized()) {
                result.setPackagingReferenceNumber(item.getPackagingReferenceNumber().getValue());
            }
        }
        return result;
    }

    private StatisticType statisticType(GoodsData item, RepairAndRefinement repairAndRefinement) {
        StatisticType result = new StatisticType();
        result.setCustomsClearanceType(item.getCustomsClearanceType().asBigInt());
        result.setCommercialGood(item.getCommercialGood().asBigInt());
        result.setStatisticalValue(BigInteger.valueOf(item.getStatisticalValueChf().getValue().longValue()));
        result.setRepair(repairAndRefinement.getRepair().isInitialized() ? repairAndRefinement.getRepair().asBigInt() : BigInteger.ZERO);
        return result;
    }

    private BusinessType business(Business b2, Consignor consignor) {
        BusinessType result = new BusinessType();
        result.setIncoterms(b2.getIncoterms().asString());
        result.setInvoiceCurrencyType(b2.getInvoiceCurrency().asBigInt());
        String vatNumber = consignor.getVatNumber().getValue();
        if (UidUtil.isValidUid(vatNumber)) {
            result.setVATNumber(UidUtil.getEdecSchemaUid(vatNumber));
            result.setVATSuffix(BigInteger.ONE);
        } else {
            result.setVATNumber(vatNumber);
            result.setVATSuffix(BigInteger.ZERO);
        }
        if (b2.getCompanyNumberTaxpayer().isInitialized()) {
            result.setCompanyNumberTaxpayer(b2.getCompanyNumberTaxpayer().getValue());
        }
        return result;
    }

    private void setCarrier(GoodsDeclarationType r, Carrier c2) {
        StringNode name = c2.getName();
        StringNode postalCode = c2.getPostalCode();
        StringNode city = c2.getCity();
        SelectionNode country = c2.getCountry();
        if (!(name.isInitialized() && postalCode.isInitialized() && city.isInitialized() && country.isInitialized())) {
            return;
        }
        GoodsDeclarationType.Carrier carrier = new GoodsDeclarationType.Carrier();
        carrier.setName(name.getValue());
        carrier.setPostalCode(postalCode.getValue());
        carrier.setCity(city.getValue());
        carrier.setCountry(country.getValue().getKey());
        if (c2.getId().isInitialized()) {
            carrier.setCarrierReference(c2.getId().getValue());
        }
        if (c2.getStreet().isInitialized()) {
            carrier.setStreet(c2.getStreet().getValue());
        }
        if (c2.getAddressSupplement1().isInitialized()) {
            carrier.setAddressSupplement1(c2.getAddressSupplement1().getValue());
        }
        if (c2.getAddressSupplement2().isInitialized()) {
            carrier.setAddressSupplement2(c2.getAddressSupplement2().getValue());
        }
        r.setCarrier(carrier);
    }

    private DeclarantType declarant(Declarant d2) {
        DeclarantType result = new DeclarantType();
        result.setName(d2.getCompanyName().getValue());
        if (d2.getStreet().isInitialized()) {
            result.setStreet(d2.getStreet().getValue());
        }
        result.setPostalCode(d2.getPostalCode().getValue());
        result.setCity(d2.getCity().getValue());
        result.setCountry(d2.getCountry().asString());
        result.setTraderIdentificationNumber(Services.get(IConfigService.class).getEdecExportIdentification());
        result.setDeclarantNumber(d2.getDeclarantNumber().asBigInt());
        return result;
    }

    private GoodsDeclarationType.Consignee createConsignee(Address c2) {
        GoodsDeclarationType.Consignee result = new GoodsDeclarationType.Consignee();
        result.setName(c2.getName().getValue());
        if (c2.getId().isInitialized()) {
            result.setConsigneeReference(c2.getId().getValue());
        }
        if (c2.getStreet().isInitialized()) {
            result.setStreet(c2.getStreet().getValue());
        }
        if (c2.getAddressSupplement1().isInitialized()) {
            result.setAddressSupplement1(c2.getAddressSupplement1().getValue());
        }
        if (c2.getAddressSupplement2().isInitialized()) {
            result.setAddressSupplement2(c2.getAddressSupplement2().getValue());
        }
        result.setPostalCode(c2.getPostalCode().getValue());
        result.setCity(c2.getCity().getValue());
        result.setCountry(c2.getCountry().asString());
        return result;
    }

    private GoodsDeclarationType.Bailor createBailor(Address c2) {
        GoodsDeclarationType.Bailor result = new GoodsDeclarationType.Bailor();
        result.setName(c2.getName().getValue());
        if (c2.getId().isInitialized()) {
            result.setBailorReference(c2.getId().getValue());
        }
        if (c2.getStreet().isInitialized()) {
            result.setStreet(c2.getStreet().getValue());
        }
        if (c2.getAddressSupplement1().isInitialized()) {
            result.setAddressSupplement1(c2.getAddressSupplement1().getValue());
        }
        if (c2.getAddressSupplement2().isInitialized()) {
            result.setAddressSupplement2(c2.getAddressSupplement2().getValue());
        }
        result.setPostalCode(c2.getPostalCode().getValue());
        result.setCity(c2.getCity().getValue());
        result.setCountry(c2.getCountry().asString());
        return result;
    }

    private GoodsDeclarationType.Vendee createVendee(Address c2) {
        GoodsDeclarationType.Vendee result = new GoodsDeclarationType.Vendee();
        result.setName(c2.getName().getValue());
        if (c2.getId().isInitialized()) {
            result.setVendeeReference(c2.getId().getValue());
        }
        if (c2.getStreet().isInitialized()) {
            result.setStreet(c2.getStreet().getValue());
        }
        if (c2.getAddressSupplement1().isInitialized()) {
            result.setAddressSupplement1(c2.getAddressSupplement1().getValue());
        }
        if (c2.getAddressSupplement2().isInitialized()) {
            result.setAddressSupplement2(c2.getAddressSupplement2().getValue());
        }
        result.setPostalCode(c2.getPostalCode().getValue());
        result.setCity(c2.getCity().getValue());
        result.setCountry(c2.getCountry().asString());
        return result;
    }

    private GoodsDeclarationType.ConsigneeSecurity createConsigneeSecurity(Address c2) {
        GoodsDeclarationType.ConsigneeSecurity result = new GoodsDeclarationType.ConsigneeSecurity();
        result.setName(c2.getName().getValue());
        if (c2.getId().isInitialized()) {
            result.setConsigneeSecurityReference(c2.getId().getValue());
        }
        if (c2.getStreet().isInitialized()) {
            result.setStreet(c2.getStreet().getValue());
        }
        if (c2.getAddressSupplement1().isInitialized()) {
            result.setAddressSupplement1(c2.getAddressSupplement1().getValue());
        }
        if (c2.getAddressSupplement2().isInitialized()) {
            result.setAddressSupplement2(c2.getAddressSupplement2().getValue());
        }
        result.setPostalCode(c2.getPostalCode().getValue());
        result.setCity(c2.getCity().getValue());
        result.setCountry(c2.getCountry().asString());
        return result;
    }

    private GoodsDeclarationType.Consignor createConsignor(Consignor c2) {
        GoodsDeclarationType.Consignor result = new GoodsDeclarationType.Consignor();
        result.setName(c2.getName().getValue());
        if (c2.getId().isInitialized()) {
            result.setConsignorReference(c2.getId().getValue());
        }
        if (c2.getStreet().isInitialized()) {
            result.setStreet(c2.getStreet().getValue());
        }
        if (c2.getAddressSupplement1().isInitialized()) {
            result.setAddressSupplement1(c2.getAddressSupplement1().getValue());
        }
        if (c2.getAddressSupplement2().isInitialized()) {
            result.setAddressSupplement2(c2.getAddressSupplement2().getValue());
        }
        result.setPostalCode(c2.getPostalCode().getValue());
        result.setCity(c2.getCity().getValue());
        result.setCountry(c2.getCountry().asString());
        if (c2.getUid().isInitialized()) {
            result.setTraderIdentificationNumber(UidUtil.getEdecSchemaUid(c2.getUid().getValue()));
        }
        return result;
    }

    private GoodsDeclarationType.ConsignorSecurity createConsignorSecurity(Consignor c2) {
        GoodsDeclarationType.ConsignorSecurity result = new GoodsDeclarationType.ConsignorSecurity();
        result.setName(c2.getName().getValue());
        if (c2.getId().isInitialized()) {
            result.setConsignorSecurityReference(c2.getId().getValue());
        }
        if (c2.getStreet().isInitialized()) {
            result.setStreet(c2.getStreet().getValue());
        }
        if (c2.getAddressSupplement1().isInitialized()) {
            result.setAddressSupplement1(c2.getAddressSupplement1().getValue());
        }
        if (c2.getAddressSupplement2().isInitialized()) {
            result.setAddressSupplement2(c2.getAddressSupplement2().getValue());
        }
        result.setPostalCode(c2.getPostalCode().getValue());
        result.setCity(c2.getCity().getValue());
        result.setCountry(c2.getCountry().asString());
        if (c2.getUid().isInitialized()) {
            result.setTraderIdentificationNumber(c2.getUid().getValue());
        }
        return result;
    }

    private void addSpecialMentionsHeader(List<SpecialMentionType> result, ListNode<SpecialMentionHeader> specialMentinos) {
        for (SpecialMentionHeader current : specialMentinos) {
            result.add(this.specialMentionType(current.getText()));
        }
    }

    private SpecialMentionType specialMentionType(StringNode specialMention) {
        SpecialMentionType result = new SpecialMentionType();
        result.setText(specialMention.getValue());
        return result;
    }

    private void addContainers(GoodsDeclarationType result, ListNode<Container> containers) {
        if (!containers.isEnabled()) {
            return;
        }
        for (Container current : containers) {
            result.getContainer().add(this.containerType(current));
        }
    }

    private ContainerType containerType(Container current) {
        ContainerType result = new ContainerType();
        result.setContainerNumber(current.getContainerNumber().getValue());
        return result;
    }

    private BigInteger inContainer(ListNode<Container> containers) {
        return containers.isEnabled() ? BigInteger.ONE : BigInteger.ZERO;
    }

    private TransportMeansType transportMeans(TransportMeans tm, BondedWarehouse bondedWarehouse) {
        TransportMeansType result = new TransportMeansType();
        result.setTransportMode(tm.getTransportMode().asBigInt());
        if (tm.getTransportationCountry().isInitialized()) {
            result.setTransportationCountry(tm.getTransportationCountry().asString());
        }
        if (bondedWarehouse.isEnabled()) {
            result.setTransportationNumber(bondedWarehouse.getTransportationNumber().getValue());
        }
        return result;
    }
}

