/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.bordereau;

import ch.e_dec.xml.schema.edecbordereaurequest.v1.BordereauRequest;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.util.DateUtil;
import java.math.BigInteger;
import java.util.Date;

public class BordereauTranslator {
    public static BordereauRequest createBordereau(String spediteurNumber, IEZVService.BordereauListEntry listEntry) {
        BordereauRequest result = BordereauTranslator.createBordereauRequest(spediteurNumber);
        result.setBordereau(BordereauTranslator.createBordereau(listEntry));
        return result;
    }

    public static BordereauRequest createBordereauList(String spediteurNumber, String accountNumber, Date startDate, Date endDate, boolean unreadOnly) {
        BordereauRequest result = BordereauTranslator.createBordereauRequest(spediteurNumber);
        result.setBordereauList(BordereauTranslator.createBordereauList(accountNumber, startDate, endDate, unreadOnly));
        return result;
    }

    private static BordereauRequest.Bordereau createBordereau(IEZVService.BordereauListEntry listEntry) {
        BordereauRequest.Bordereau result = new BordereauRequest.Bordereau();
        result.setBordereauNumber(listEntry.bordereauNumber);
        result.setProcessingCenterNumber(listEntry.processingCenterNumber);
        result.setCreationDate(listEntry.creationDate);
        return result;
    }

    private static BordereauRequest.BordereauList createBordereauList(String accountNumber, Date startDate, Date endDate, boolean unreadOnly) {
        BordereauRequest.BordereauList result = new BordereauRequest.BordereauList();
        if (unreadOnly) {
            result.setDocumentStatus("unread");
        }
        result.setDateRange(BordereauTranslator.createDateRange(startDate, endDate));
        result.setAccountNumber(new BigInteger(accountNumber));
        return result;
    }

    private static BordereauRequest.BordereauList.DateRange createDateRange(Date startDate, Date endDate) {
        BordereauRequest.BordereauList.DateRange result = new BordereauRequest.BordereauList.DateRange();
        result.setStartDate(DateUtil.toXmlGregorianCalendar(startDate));
        result.setEndDate(DateUtil.toXmlGregorianCalendar(endDate));
        return result;
    }

    private static BordereauRequest createBordereauRequest(String spediteurNumber) {
        BordereauRequest result = new BordereauRequest();
        result.setRequestorTraderIdentificationNumber(spediteurNumber);
        result.setSchemaVersion(Services.get(IEZVService.class).getBordereauVersion());
        return result;
    }
}

