/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.evv;

import ch.e_dec.services.edecreceiptservice.v3.ReceiptRequestFault;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.DescriptionType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.ErrorType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.ReceiptRequestRejectionType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.ReceiptRequestResponse;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.RuleErrorType;
import ch.e_dec.xml.schema.edecreceiptresponse.v3.XMLSchemaErrorType;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.ErrorUtil;
import java.util.ArrayList;
import java.util.List;

public class EvvErrorHandler {
    private final ReceiptRequestFault error;

    public EvvErrorHandler(ReceiptRequestFault error) {
        this.error = error;
        this.handleError();
    }

    private void handleError() {
        List<String> errors = EvvErrorHandler.createErrorList(this.error);
        ErrorUtil.showErrors("Error fetching Receipt", errors);
    }

    public static List<String> createErrorList(ReceiptRequestFault error) {
        ReceiptRequestResponse rep = error.getFaultInfo();
        ReceiptRequestRejectionType rejection = rep.getReceiptRequestRejection();
        ReceiptRequestRejectionType.Errors errors = rejection.getErrors();
        if (errors.getXMLSchemaErrors() != null) {
            return EvvErrorHandler.handleSchemaErrors(errors.getXMLSchemaErrors());
        }
        if (errors.getRuleErrors() != null) {
            return EvvErrorHandler.handleRuleErrors(errors.getRuleErrors());
        }
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.add("No Error found");
        return errorList;
    }

    private static List<String> handleRuleErrors(RuleErrorType ruleErrors) {
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.add("Evv Rule Error");
        if (ruleErrors != null) {
            for (RuleErrorType.Error error : ruleErrors.getError()) {
                errorList.add(EvvErrorHandler.getRuleErrorDescription(error));
            }
        }
        return errorList;
    }

    private static List<String> handleSchemaErrors(XMLSchemaErrorType xmlSchemaErrors) {
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.add("Evv schema error");
        for (ErrorType error : xmlSchemaErrors.getError()) {
            errorList.add(error.getMessage());
        }
        return errorList;
    }

    public static String getRuleErrorDescription(RuleErrorType.Error error) {
        return EvvErrorHandler.getDescription(error) + " (" + error.getRuleName() + ")";
    }

    private static String getDescription(RuleErrorType.Error error) {
        if (error.getRuleName().equals("R233")) {
            return Services.getText(914);
        }
        if (error.getRuleName().equals("v12")) {
            throw Check.fail("invalid date range for fetching eVV");
        }
        ITextService.Language language = Services.get(ITextService.class).getCurrentLanguage();
        List<DescriptionType.Description> descriptions = error.getDescriptions().getDescription();
        for (DescriptionType.Description current : descriptions) {
            if (!current.getLanguage().equals(language.name())) continue;
            return current.getContent();
        }
        if (descriptions.isEmpty()) {
            return Services.getText(915);
        }
        return descriptions.get(0).getContent();
    }
}

