/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.evv;

import ch.e_dec.xml.schema.edecreceiptrequest.v3.DocumentTypeTypeList;
import ch.e_dec.xml.schema.edecreceiptrequest.v3.ReceiptRequestType;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.service.ezv.evv.Role;
import ch.transsoft.edec.util.DateUtil;
import java.math.BigInteger;
import java.util.Date;

public class EvvTranslator {
    public static ReceiptRequestType createReceipt(String uid, String customsDeclarationNumber, BigInteger customsDeclarationVersion, ReceiptDocumentType docType) {
        ReceiptRequestType result = EvvTranslator.createReceiptRequestType(uid);
        result.setReceipt(EvvTranslator.createReceipt(customsDeclarationNumber, customsDeclarationVersion, docType));
        return result;
    }

    public static ReceiptRequestType createReceiptListImport(String importID, Date startDate, Date endDate, Role role, String zazAccount) {
        ReceiptRequestType result = EvvTranslator.createReceiptRequestType(importID);
        result.setReceiptList(EvvTranslator.createReceiptListImport(startDate, endDate, role, zazAccount));
        return result;
    }

    public static ReceiptRequestType createReceiptListExport(String exportID, Date startDate, Date endDate, Role role) {
        ReceiptRequestType result = EvvTranslator.createReceiptRequestType(exportID);
        result.setReceiptList(EvvTranslator.createReceiptListExport(startDate, endDate, role));
        return result;
    }

    private static ReceiptRequestType createReceiptRequestType(String requesterTraderIdentificationNumber) {
        ReceiptRequestType result = new ReceiptRequestType();
        result.setRequestorTraderIdentificationNumber(requesterTraderIdentificationNumber);
        result.setSchemaVersion(Services.get(IEZVService.class).getEvvVersion());
        return result;
    }

    private static ReceiptRequestType.Receipt createReceipt(String customsDeclarationNumber, BigInteger customsDeclarationVersion, ReceiptDocumentType docType) {
        ReceiptRequestType.Receipt result = new ReceiptRequestType.Receipt();
        result.setCustomsDeclarationNumber(customsDeclarationNumber);
        if (customsDeclarationVersion != null) {
            result.setCustomsDeclarationVersion(customsDeclarationVersion);
        }
        result.setDocumentType(docType.getDocumentType());
        return result;
    }

    private static ReceiptRequestType.ReceiptList createReceiptListExport(Date startDate, Date endDate, Role role) {
        ReceiptRequestType.ReceiptList result = new ReceiptRequestType.ReceiptList();
        result.setDocumentTypeList(DocumentTypeTypeList.TAXATION_DECISION_EXPORT);
        result.setDateRange(EvvTranslator.createDateRange(startDate, endDate));
        result.setRole(BigInteger.valueOf(role.ordinal()));
        return result;
    }

    private static ReceiptRequestType.ReceiptList createReceiptListImport(Date startDate, Date endDate, Role role, String zazKonto) {
        ReceiptRequestType.ReceiptList result = new ReceiptRequestType.ReceiptList();
        result.setDateRange(EvvTranslator.createDateRange(startDate, endDate));
        result.setRole(BigInteger.valueOf(role.ordinal()));
        result.setAccountNumber(zazKonto);
        result.setDocumentTypeList(DocumentTypeTypeList.ALL_IMPORT_TAXATION_DECISIONS_AND_REFUNDS);
        return result;
    }

    private static ReceiptRequestType.ReceiptList.DateRange createDateRange(Date startDate, Date endDate) {
        ReceiptRequestType.ReceiptList.DateRange result = new ReceiptRequestType.ReceiptList.DateRange();
        result.setStartDate(DateUtil.toXmlGregorianCalendar(startDate));
        result.setEndDate(DateUtil.toXmlGregorianCalendar(endDate));
        return result;
    }
}

