/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.evv.sigcheck;

import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.certificate.ICertificateService;
import ch.transsoft.edec.service.ezv.evv.sigcheck.ValidatorResult;
import ch.transsoft.edec.service.ezv.evv.sigcheck.builder.X509CertificateBuilder;
import ch.transsoft.edec.service.ezv.evv.sigcheck.context.ProviderSelectorImpl;
import ch.transsoft.edec.service.ezv.evv.sigcheck.context.SystemContext;
import ch.transsoft.edec.service.ezv.evv.sigcheck.context.SystemContextImpl;
import ch.transsoft.edec.service.ezv.evv.sigcheck.out.OutputterStrategy;
import ch.transsoft.edec.service.ezv.evv.sigcheck.out.StreamOutputter;
import ch.transsoft.edec.service.ezv.evv.sigcheck.validator.X509CertificateValidator;
import ch.transsoft.edec.service.ezv.evv.sigcheck.validator.XMLSignatureValidator;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.SendingUtil;
import ch.transsoft.edec.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentValidator {
    private static String VERSION = "development";
    private static boolean showSystemInfo;

    public static void main(String[] args) throws Exception {
        String inputCRL = null;
        String outputDir = "\\T:\\cert";
        String inputFile = "T:\\cert\\evv.xml";
        DocumentValidator validator2 = new DocumentValidator();
        validator2.validate(new FileInputStream(inputFile), inputFile, inputCRL, outputDir);
    }

    public static void addValidationInfo(byte[] input, String inputName, ReceiptDocument document) {
        ValidatorResult validationResult = DocumentValidator.validate(input, inputName);
        if (validationResult.isValid()) {
            document.getState().setValue(ReceiptDocument.State.DOC_VALID.getValueAsLong());
        } else {
            document.getState().setValue(ReceiptDocument.State.DOC_INVALID.getValueAsLong());
        }
        document.getValidationProtocol().setValue(validationResult.getProtocol());
    }

    public static boolean validateFromFile(File inputFile, String sendingId) throws Exception {
        File sendingDir = SendingUtil.getSendingDir(sendingId, false);
        return new DocumentValidator().validate(new FileInputStream(inputFile), inputFile.getAbsolutePath(), null, sendingDir.getAbsolutePath());
    }

    public boolean validate(InputStream is, String inputName, String inputCRL, String outputFileName) throws FileNotFoundException {
        File outFile = new File(outputFileName, "eVV Signature Check.txt");
        FileOutputStream out = new FileOutputStream(outFile);
        return this.validate(is, inputName, out);
    }

    public static ValidatorResult validate(byte[] input, String inputName) {
        return DocumentValidator.validate(new ByteArrayInputStream(input), inputName);
    }

    public static ValidatorResult validate(InputStream is, String inputName) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean result = new DocumentValidator().validate(is, inputName, out);
        return new ValidatorResult(result, out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(InputStream is, String inputName, OutputStream protocol) {
        SystemContext context = this.createSystemContext(protocol);
        OutputterStrategy out = context.getOutputterStrategy();
        try {
            out.write("### --- START --- ####");
            if (showSystemInfo) {
                out.write("signature validator version: " + VERSION);
                out.write("system jre version: " + System.getProperty("java.version"));
                out.write("system jre vendor: " + System.getProperty("java.vendor"));
                out.write("system jre home: " + System.getProperty("java.home"));
                out.write("system os: " + System.getProperty("os.name"));
                out.write("system os version: " + System.getProperty("os.version"));
            }
            out.write("input eVV file: " + inputName);
            out.write("date of check: " + String.valueOf(new Date()));
            Document xmldoc = XMLUtil.read(is);
            is.close();
            this.fixDocument((CoreDocumentImpl)xmldoc);
            Node timestamp = XMLUtil.extractTimeStamp(xmldoc);
            if (timestamp != null) {
                out.write("timestamp: " + timestamp.getTextContent());
            }
            Date checkDate = this.getDateFromTimestampNode(timestamp);
            Node evvInfo = XMLUtil.extractDocumentInformation(xmldoc);
            if (evvInfo != null) {
                out.write(evvInfo.getChildNodes());
            } else {
                out.write("documentInformation: NO CONTENT");
            }
            out.write(XMLUtil.extractTraderDeclarationNumber(xmldoc));
            out.write(XMLUtil.extractTraderReference(xmldoc));
            Node x509token = XMLUtil.extractX509Token(xmldoc);
            X509CertificateBuilder builder = new X509CertificateBuilder(context);
            X509Certificate x509 = builder.createCertificate(x509token.getTextContent());
            out.write("certificate", x509);
            Node dsSignature = XMLUtil.extractDSignature(xmldoc);
            XMLSignatureValidator sigValidator = new XMLSignatureValidator(context, x509.getPublicKey());
            boolean sigValid = sigValidator.isValid(dsSignature);
            out.write("check signature: " + (sigValid ? "OK" : "NOT OK"));
            boolean certValid = this.validateCertificates(context, out, checkDate, builder, x509);
            String status = certValid ? "OK" : "NOT OK";
            out.write("check certificate: " + status);
            boolean bl = certValid && sigValid;
            return bl;
        }
        catch (Exception e2) {
            Services.get(ILoggingService.class).logSilentWithBugMail(e2, "Error when validating eVV signature");
            boolean bl = false;
            return bl;
        }
        finally {
            out.write("### --- END --- ###");
            out.close();
        }
    }

    private boolean validateCertificates(SystemContext context, OutputterStrategy out, Date checkDate, X509CertificateBuilder builder, X509Certificate x509) throws CertificateException, NoSuchProviderException {
        for (InputStream certificate : Services.get(ICertificateService.class).getEzvRootCertificates()) {
            X509Certificate ca = builder.createCertificateFromStream(certificate);
            if (!this.validateCertificate(x509, ca, checkDate, context, out)) continue;
            return true;
        }
        return false;
    }

    private boolean validateCertificate(X509Certificate x509, X509Certificate ca, Date checkDate, SystemContext context, OutputterStrategy out) {
        out.write("CA", ca);
        X509CertificateValidator x509validator = new X509CertificateValidator(context, ca);
        x509validator.setDate(checkDate);
        out.write("check certificate date: " + String.valueOf(checkDate));
        return x509validator.isValid(x509);
    }

    private void fixDocument(CoreDocumentImpl xmldoc) throws XPathExpressionException {
        Element timestamp = (Element)XMLUtil.findNode(xmldoc, "//wsu:Timestamp");
        if (timestamp == null) {
            return;
        }
        xmldoc.putIdentifier(timestamp.getAttribute("wsu:Id"), timestamp);
        Element body = (Element)XMLUtil.findNode(xmldoc, "//SOAP-ENV:Body");
        xmldoc.putIdentifier(body.getAttribute("wsu:Id"), body);
    }

    private Date getDateFromTimestampNode(Node timestamp) throws ParseException {
        Date date;
        if (timestamp == null) {
            return new Date();
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
            date = sdf.parse(timestamp.getTextContent());
        }
        catch (ParseException pex) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            date = sdf.parse(timestamp.getTextContent());
        }
        return date;
    }

    private SystemContext createSystemContext(OutputStream out) {
        SystemContextImpl context = new SystemContextImpl();
        StreamOutputter fileOutputter = new StreamOutputter(out);
        context.setOutputterStrategy(fileOutputter);
        ProviderSelectorImpl selector = new ProviderSelectorImpl();
        context.setProviderSelector(selector);
        return context;
    }

    static {
        try {
            VERSION = ResourceBundle.getBundle("version").getString("releaseVersion");
        }
        catch (Exception exception) {
            // empty catch block
        }
        showSystemInfo = true;
    }
}

