/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.evv.sigcheck.builder;

import ch.transsoft.edec.service.ezv.evv.sigcheck.context.SystemContext;
import ch.transsoft.edec.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class X509CertificateBuilder {
    private static final String HEADER = "-----BEGIN CERTIFICATE-----\n";
    private static final String FOOTER = "\n-----END CERTIFICATE-----";
    private SystemContext context;

    public X509CertificateBuilder(SystemContext context) {
        this.context = context;
    }

    public X509Certificate createCertificate(String content) throws CertificateException, NoSuchProviderException {
        byte[] x509data = (HEADER + content + FOOTER).getBytes();
        ByteArrayInputStream bis = new ByteArrayInputStream(x509data);
        CertificateFactory cf = this.context.getProviderSelector().getCertificateFactory();
        return (X509Certificate)cf.generateCertificate(bis);
    }

    public X509Certificate createCertificateFromPath(String path) throws CertificateException, FileNotFoundException, NoSuchProviderException {
        File file = new File(path);
        FileInputStream is = new FileInputStream(file);
        return this.createCertificateFromStream(is);
    }

    public X509Certificate createCertificateFromStream(InputStream is) throws CertificateException, NoSuchProviderException {
        CertificateFactory cf = this.context.getProviderSelector().getCertificateFactory();
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        FileUtil.close(is);
        return cert;
    }
}

