/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.ezv.evv.sigcheck.out;

import ch.transsoft.edec.model.infra.node.BinaryNode;
import ch.transsoft.edec.service.ezv.evv.sigcheck.out.OutputterStrategy;
import ch.transsoft.edec.util.Check;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StreamOutputter
implements OutputterStrategy {
    protected PrintWriter writer;

    public StreamOutputter(OutputStream os) {
        try {
            this.writer = new PrintWriter(new OutputStreamWriter(os, BinaryNode.DEFAULT_CHARSET.name()));
        }
        catch (UnsupportedEncodingException e2) {
            Check.fail(e2);
        }
    }

    @Override
    public void write(String str) {
        this.writer.println(str);
        this.writer.flush();
    }

    @Override
    public void write(String prefix, X509Certificate cert) {
        if (cert != null) {
            this.writer.println(prefix + " issuer DN: " + String.valueOf(cert.getIssuerDN()));
            this.writer.println(prefix + " subject DN: " + String.valueOf(cert.getSubjectDN()));
            this.writer.println(prefix + " valid from: " + String.valueOf(cert.getNotBefore()));
            this.writer.println(prefix + " valid to: " + String.valueOf(cert.getNotAfter()));
        } else {
            this.writer.println(prefix + " NOT SET");
        }
        this.writer.flush();
    }

    @Override
    public void write(String prefix, X509CRL crl) {
        if (crl != null) {
            this.writer.println(prefix + " issuer DN: " + String.valueOf(crl.getIssuerDN()));
            this.writer.println(prefix + " valid from: " + String.valueOf(crl.getThisUpdate()));
            this.writer.println(prefix + " next update: " + String.valueOf(crl.getNextUpdate()));
        } else {
            this.writer.println(prefix + " NOT SET");
        }
        this.writer.flush();
    }

    @Override
    public void write(NodeList list) {
        if (list != null) {
            int size = list.getLength();
            for (int i2 = 0; i2 < size; ++i2) {
                Node current = list.item(i2);
                if (1 != current.getNodeType()) continue;
                this.writer.println(current.getLocalName() + ": " + current.getTextContent());
            }
        }
        this.writer.flush();
    }

    @Override
    public void write(Node node) {
        if (node != null) {
            this.writer.println(node.getLocalName() + ": " + node.getTextContent());
        }
        this.writer.flush();
    }

    @Override
    public void write(String prefix, Exception ex) {
        if (ex != null) {
            this.writer.println(prefix + ": " + ex.toString());
            for (StackTraceElement ste : ex.getStackTrace()) {
                this.writer.println("   " + ste.toString());
            }
        }
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

