/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form;

import ch.transsoft.edec.model.infra.XMLReader;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.desc.FormPageDesc;
import ch.transsoft.edec.service.form.desc.GoodsItemDesc;
import ch.transsoft.edec.service.form.desc.LabelDesc;
import ch.transsoft.edec.service.form.desc.LineDesc;
import ch.transsoft.edec.service.form.desc.NodeDesc;
import ch.transsoft.edec.service.form.editor.gui.controls.BooleanField;
import ch.transsoft.edec.service.form.render.DataContext;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.ui.gui.control.InfoIcon;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.LinkLabel;
import ch.transsoft.edec.ui.gui.control.RadioButton;
import ch.transsoft.edec.ui.gui.control.StringArea;
import ch.transsoft.edec.ui.gui.control.StringField;
import ch.transsoft.edec.ui.gui.control.combo.SelectionField;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.RadioButtonUtil;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

public abstract class AbstractFormPageDesc
implements IFormPageDesc {
    private final FormPageDesc formDesc = this.readDesc();
    private final Sending.FormName formName;

    public AbstractFormPageDesc(Sending.FormName formName) {
        this.formName = formName;
    }

    private FormPageDesc readDesc() {
        URL descUrl = this.getDescUrl();
        Check.assertNotNull(descUrl, "no desc for " + this.getClass().getSimpleName());
        try {
            XMLReader reader = new XMLReader();
            return reader.read(descUrl.openStream(), FormPageDesc.class);
        }
        catch (Exception e2) {
            throw Check.fail(e2, "form-desc konnte nicht gelesen werden: ", descUrl);
        }
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel pageContentPanel, IUnitConverter c2) {
    }

    @Override
    public void addStaticControls(JPanel panel, IUnitConverter c2) {
    }

    public FormPageDesc getDesc() {
        return this.formDesc;
    }

    @Override
    public ListNode<GoodsItemDesc> getGoodsItems() {
        return this.formDesc.getGoodsItems();
    }

    @Override
    public ListNode<LineDesc> getLines() {
        return this.formDesc.getLines();
    }

    @Override
    public ListNode<LabelDesc> getLabels() {
        return this.formDesc.getLabels();
    }

    @Override
    public ListNode<NodeDesc> getNodes() {
        return this.formDesc.getNodes();
    }

    @Override
    public String getUnitName(int units) {
        return units == 1 ? Services.getText(699) : Services.getText(702);
    }

    @Override
    public boolean carryOverIsLineItem() {
        return true;
    }

    @Override
    public int getNumberOfCopies() {
        return 1;
    }

    protected JRadioButton addRadioButton(JPanel panel, IUnitConverter c2, ButtonGroup radioGroup, double x, double y, String label) {
        JRadioButton radioButton = this.addRadioButton(c2, radioGroup, x, y, label);
        panel.add(radioButton);
        return radioButton;
    }

    protected JRadioButton addRadioButton(IUnitConverter c2, ButtonGroup radioGroup, double x, double y, String text) {
        JRadioButton radioButton = this.addRadioButton(c2, radioGroup, x, y, text, UIManager.getFont("RadioButton.font"));
        this.scaleFont(radioButton, c2.getZoom());
        this.setPreferredComponentSize(radioButton);
        return radioButton;
    }

    protected JRadioButton addRadioButton(JPanel panel, IUnitConverter c2, ButtonGroup radioGroup, double x, double y, String label, Font font) {
        JRadioButton radioButton = this.addRadioButton(c2, radioGroup, x, y, label, font);
        panel.add(radioButton);
        return radioButton;
    }

    protected JRadioButton addRadioButton(IUnitConverter c2, ButtonGroup radioGroup, double x, double y, String text, Font font) {
        RadioButton radioButton = new RadioButton(text, true);
        radioButton.setOpaque(false);
        radioButton.setLocation(c2.px(x), c2.py(y));
        radioButton.setFont(font);
        radioButton.setIcon(this.scaleIcon(UIManager.getIcon("RadioButton.icon"), radioButton, c2.getZoom()));
        this.setPreferredComponentSize(radioButton);
        radioGroup.add(radioButton);
        return radioButton;
    }

    protected JRadioButton addHtmlRadioButton(JPanel panel, final IUnitConverter c2, ButtonGroup radioGroup, double x, double y, String label) {
        RadioButton radioButton = new RadioButton(label, true){

            @Override
            public void paintComponent(Graphics g2) {
                AbstractFormPageDesc.this.translateComponent(g2, this.getHeight(), c2.getZoom());
                AbstractFormPageDesc.this.scaleGraphics(g2, c2.getZoom());
                super.paintComponent(g2);
            }
        };
        radioButton.setSize(this.scaleDimension(radioButton.getPreferredSize(), c2.getZoom()));
        radioButton.setLocation(c2.px(x), c2.py(y));
        radioButton.setOpaque(false);
        radioGroup.add(radioButton);
        panel.add(radioButton);
        return radioButton;
    }

    protected void connectRadio(Disposables disposables, ButtonGroup radioGroup, IntegralNode node, JRadioButton ... radioButtons) {
        RadioButtonUtil.connectRadio(disposables, radioGroup, node, radioButtons);
    }

    protected BooleanField addCheckBox(Disposables disposables, JPanel panel, IUnitConverter c2, String text, BooleanNode node, double x, double y) {
        BooleanField checkbox = new BooleanField(node);
        checkbox.setText(text);
        checkbox.setOpaque(false);
        checkbox.setLocation(c2.px(x), c2.py(y));
        this.scaleFont(checkbox, c2.getZoom());
        checkbox.setIcon(this.scaleIcon(UIManager.getIcon("CheckBox.icon"), checkbox, c2.getZoom()));
        this.setPreferredComponentSize(checkbox);
        panel.add(checkbox);
        disposables.add(node.addChangeListener((source, info) -> checkbox.setSelected(node.getValue())));
        return checkbox;
    }

    protected void addSelectionField(JPanel panel, SelectionPm pm, IUnitConverter c2, double x, double y, double width, double height) {
        SelectionField<DomainValue> selectionField = new SelectionField<DomainValue>(pm);
        this.scaleFont(selectionField, c2.getZoom());
        selectionField.setBounds(c2.px(x), c2.py(y), c2.px(width), c2.py(height));
        panel.add(selectionField);
    }

    protected void addLinkedLabel(JPanel panel, IUnitConverter c2, String url, String label, double x, double y) {
        LinkLabel linkLabel = new LinkLabel("url", url, "<a href=url>" + label + "</a> ");
        this.scaleFont(linkLabel, c2.getZoom());
        this.setPreferredComponentSize(linkLabel);
        linkLabel.setLocation(c2.px(x), c2.py(y));
        panel.add(linkLabel);
    }

    protected LinkLabel addLinkedLabel(JPanel panel, IUnitConverter c2, String href, String url, String text, double x, double y, int width, int height) {
        LinkLabel linkLabel = new LinkLabel(href, url, text);
        this.scaleFont(linkLabel, c2.getZoom());
        linkLabel.setBounds(c2.px(x), c2.py(y), c2.px(width), c2.py(height));
        panel.add(linkLabel);
        return linkLabel;
    }

    protected Label addLabel(JPanel panel, IUnitConverter c2, Fonts font, String text, double x, double y, int width, int height) {
        Label label = new Label(text);
        label.setFont(c2.getFont(font));
        label.setBounds(c2.px(x), c2.py(y), c2.px(width), c2.py(height));
        panel.add(label);
        return label;
    }

    protected StringArea addStringArea(JPanel panel, StringPm stringPm) {
        return this.addStringArea(panel, stringPm, 5);
    }

    protected StringArea addStringArea(JPanel panel, StringPm stringPm, int rows) {
        StringArea stringArea = new StringArea(stringPm, rows);
        panel.add(stringArea);
        return stringArea;
    }

    protected StringArea addStringArea(Disposables disposables, StringNode node, PageContentPanel panel, IUnitConverter c2, int x, int y, int width, int rows) {
        StringPm stringPm = new StringPm(node);
        disposables.add(stringPm);
        StringArea stringArea = new StringArea(stringPm, rows);
        stringArea.getTextArea().setFont(c2.getFont(Fonts.font8));
        stringArea.setBounds(new Rectangle(c2.px(x), c2.py(y), c2.px(width), c2.py((double)rows * 3.65)));
        panel.add(stringArea);
        return stringArea;
    }

    protected StringField addStringField(StringPm fieldPm) {
        return new StringField(fieldPm);
    }

    protected void addInfoIcon(JPanel panel, final IUnitConverter c2, Integer helpPage, boolean big, double xmm, double ymm, int sizePx) {
        InfoIcon infoIcon = new InfoIcon(helpPage, big){

            @Override
            public void paintComponent(Graphics g2) {
                AbstractFormPageDesc.this.scaleGraphics(g2, c2.getZoom());
                super.paintComponent(g2);
            }
        };
        infoIcon.setBounds(c2.px(xmm), c2.py(ymm), (int)(c2.getZoom() * (double)sizePx), (int)(c2.getZoom() * (double)sizePx));
        panel.add(infoIcon);
    }

    @Override
    public String getPrintName() {
        return this.getGuiName();
    }

    protected void addRowsListener(Disposables disposables, DataContext dataContext, StringArea freeText, int maxNumberOfRows) {
        disposables.add(dataContext.addChangeListener(this.createChangeListener(dataContext, freeText, maxNumberOfRows)));
        this.updateFreeTextVisibility(dataContext, freeText, maxNumberOfRows);
    }

    private IChangeListener createChangeListener(IDataContext dataContext, StringArea freeText, int maxNumberOfRows) {
        return (source, info) -> this.updateFreeTextVisibility(dataContext, freeText, maxNumberOfRows);
    }

    private void updateFreeTextVisibility(IDataContext dataContext, StringArea freeText, int maxNumberOfRows) {
        freeText.setVisible(this.showFreeText(dataContext, maxNumberOfRows));
    }

    protected boolean showFreeText(IDataContext dataContext, int maxNumberOfRows) {
        if (dataContext.getPageCount() > 1) {
            return false;
        }
        return dataContext.getFirstPageLineCount() <= maxNumberOfRows;
    }

    protected JButton addButton(PageContentPanel panel, IUnitConverter c2, String label, int x, int y, double width, double height) {
        JButton button = new JButton(label);
        button.setBounds(c2.px(x), c2.py(y), c2.px(width), c2.py(height));
        this.scaleFont(button, c2.getZoom());
        button.setMargin(new Insets(0, 0, 0, 0));
        panel.add(button);
        return button;
    }

    @Override
    public Color getTextBackgroundColor() {
        return Design.CONTROL_BG;
    }

    @Override
    public final Sending.FormName getFormName() {
        return this.formName;
    }

    protected ItemList getItemList(Sending sending) {
        return sending.getItemListForForm(this.getFormName());
    }

    private Dimension scaleDimension(Dimension d2, double zoomScale) {
        double width = d2.getWidth() * zoomScale;
        double height = d2.getHeight() * zoomScale;
        return new Dimension((int)width, (int)height);
    }

    private void scaleGraphics(Graphics g2, double zoomScale) {
        Graphics2D g2d = (Graphics2D)g2;
        g2d.scale(zoomScale, zoomScale);
    }

    private void translateComponent(Graphics g2, int height, double zoomScale) {
        double translateY = -(zoomScale - 1.0) * (double)height / 2.0;
        g2.translate(0, (int)translateY);
    }

    private void scaleFont(Component c2, double zoomScale) {
        Font font = c2.getFont();
        AffineTransform at = new AffineTransform();
        at.scale(zoomScale, zoomScale);
        c2.setFont(font.deriveFont(at));
    }

    private Icon scaleIcon(final Icon originalIcon, final Component component, final double zoomScale) {
        return new Icon(){

            @Override
            public void paintIcon(Component c2, Graphics g2, int x, int y) {
                Graphics2D gNew = (Graphics2D)g2.create();
                gNew.scale(zoomScale, zoomScale);
                originalIcon.paintIcon(component, gNew, (int)Math.round((double)x / zoomScale), (int)Math.round((double)y / zoomScale));
                gNew.dispose();
            }

            @Override
            public int getIconWidth() {
                return (int)((double)originalIcon.getIconWidth() * zoomScale);
            }

            @Override
            public int getIconHeight() {
                return (int)((double)originalIcon.getIconHeight() * zoomScale);
            }
        };
    }

    protected void setPreferredComponentSize(Component c2) {
        c2.setSize(c2.getPreferredSize());
    }
}

