/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.desc;

import ch.transsoft.edec.model.infra.annotation.decimalSpec;
import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.enumType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.EnumNode;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.desc.ITextDesc;
import ch.transsoft.edec.service.form.desc.TextStrategy;
import java.util.ArrayList;
import java.util.List;

public final class NodeDesc
extends ListEntry<NodeDesc>
implements ITextDesc {
    private StringNode nodePath;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="0")
    private DecimalNode x;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="0")
    private DecimalNode y;
    @decimalSpec(totalDigits=10, fractionDigits=1)
    @defaultValue(value="50")
    private DecimalNode width;
    @defaultValue(value="1")
    private IntegralNode height;
    @enumType(value=TextStrategy.class)
    @defaultValue(value="none")
    private EnumNode<TextStrategy> textStrategy;
    @enumType(value=Fonts.class)
    @defaultValue(value="font10")
    private EnumNode<Fonts> font;
    @mandatory
    @defaultValue(value="true")
    private BooleanNode editable;
    @mandatory
    @defaultValue(value="false")
    private BooleanNode alignRight;
    @mandatory
    private BooleanNode suppressPrint;
    @mandatory
    private BooleanNode findAll;
    @defaultValue(value="0")
    private IntegralNode lineExtension;

    @Override
    public DecimalNode getX() {
        return this.x;
    }

    @Override
    public DecimalNode getY() {
        return this.y;
    }

    @Override
    public DecimalNode getWidth() {
        return this.width;
    }

    @Override
    public IntegralNode getHeight() {
        return this.height;
    }

    public EnumNode<TextStrategy> getTextStrategy() {
        return this.textStrategy;
    }

    public EnumNode<Fonts> getFont() {
        return this.font;
    }

    public StringNode getNodePath() {
        return this.nodePath;
    }

    public BooleanNode getEditable() {
        return this.editable;
    }

    public BooleanNode getAlignRight() {
        return this.alignRight;
    }

    public List<String> getTextValues(Sending sending) {
        List<INode<?>> nodes = sending.findAll(this.getNodePath().getValue());
        ArrayList<String> result = new ArrayList<String>();
        for (INode<?> node : nodes) {
            result.add(((IPrimitive)node).getStringValue());
        }
        return result;
    }

    public String getTextValue(Sending sending) {
        return this.getPrimitive(sending).toString();
    }

    public IPrimitive<?> getPrimitive(Sending sending) {
        return (IPrimitive)sending.find(this.getNodePath().getValue());
    }

    @Override
    public TextStrategy getTextStrategyValue() {
        return this.getTextStrategy().getValue();
    }

    @Override
    public boolean splitAtWhitespace() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return this.getEditable().getValue();
    }

    @Override
    public Fonts getFontValue() {
        return this.getFont().getValue();
    }

    public BooleanNode getSuppressPrint() {
        return this.suppressPrint;
    }

    public BooleanNode getFindAll() {
        return this.findAll;
    }

    public IntegralNode getLineExtension() {
        return this.lineExtension;
    }

    @Override
    public int getLineExtensionPx() {
        return this.getLineExtension().getIntValue();
    }
}

