/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.editor.gui;

import ch.transsoft.edec.service.form.FormConst;
import ch.transsoft.edec.service.form.editor.gui.DragControl;
import ch.transsoft.edec.service.form.editor.gui.controls.IElement;
import ch.transsoft.edec.service.form.editor.model.EditorModel;
import ch.transsoft.edec.service.form.editor.model.IEditorModelListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class CenterPanel
extends JPanel
implements Scrollable {
    private final EditorModel model;
    private DragControl dragControl;

    public CenterPanel(EditorModel model) {
        this.model = model;
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setPreferredSize(FormConst.getDimension());
        this.addAllElements();
        model.addStaticControls(this);
        this.addListener();
    }

    private void addAllElements() {
        for (IElement element : this.model.getElements()) {
            this.addToForm(element);
        }
    }

    private void addListener() {
        this.model.getDesc().addChangeListener((source, info) -> {
            this.revalidate();
            this.repaint();
        });
        this.model.add(new IEditorModelListener(){

            @Override
            public void selected(IElement element) {
            }

            @Override
            public void removed(IElement element) {
                CenterPanel.this.removeFromForm(element);
            }

            @Override
            public void added(IElement element) {
                CenterPanel.this.addToForm(element);
                CenterPanel.this.model.triggerSelectionChanged(element);
            }
        });
    }

    private void removeFromForm(IElement element) {
        this.remove(element.getComponent());
        this.repaint();
    }

    private void addToForm(final IElement element) {
        final JComponent component = element.getComponent();
        this.add(component);
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                CenterPanel.this.model.triggerSelectionChanged(element);
                CenterPanel.this.dragControl = new DragControl(component, element, e2);
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                CenterPanel.this.dragControl.finish();
                CenterPanel.this.dragControl = null;
                CenterPanel.this.repaint();
            }
        });
        component.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                CenterPanel.this.dragControl.drag(e2);
                CenterPanel.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e2) {
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 50;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 50;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(0, 0);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }
}

