/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.editor.gui;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.editor.gui.CenterPanel;
import ch.transsoft.edec.service.form.editor.gui.ChangeFormAction;
import ch.transsoft.edec.service.form.editor.gui.PropertiesContainer;
import ch.transsoft.edec.service.form.editor.gui.action.AddGoodsItemAction;
import ch.transsoft.edec.service.form.editor.gui.action.AddLabelAction;
import ch.transsoft.edec.service.form.editor.gui.action.AddLineAction;
import ch.transsoft.edec.service.form.editor.gui.action.AddNodeAction;
import ch.transsoft.edec.service.form.editor.gui.action.DeleteAction;
import ch.transsoft.edec.service.form.editor.gui.action.SaveAction;
import ch.transsoft.edec.service.form.editor.model.EditorModel;
import ch.transsoft.edec.service.form.forms.bg.BGBack;
import ch.transsoft.edec.service.form.forms.bg.BGFront;
import ch.transsoft.edec.service.form.forms.bill.BillLayout1;
import ch.transsoft.edec.service.form.forms.cmr.CmrDeFr;
import ch.transsoft.edec.service.form.forms.cmr.CmrEnFr;
import ch.transsoft.edec.service.form.forms.deliverynote.DeliveryNoteLayout1;
import ch.transsoft.edec.service.form.forms.emergency.EmergencyHeader;
import ch.transsoft.edec.service.form.forms.emergency.EmergencyItems;
import ch.transsoft.edec.service.form.forms.eur1.Eur1Back;
import ch.transsoft.edec.service.form.forms.eur1.Eur1Front;
import ch.transsoft.edec.service.form.forms.list.ItemListFormFront;
import ch.transsoft.edec.service.form.forms.spedi.SpediFront;
import ch.transsoft.edec.service.form.forms.uz.UZlayout1;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class EditorPanel
extends JPanel {
    private final AddLabelAction addLabelAction;
    private final AddNodeAction addNodeAction;
    private final AddGoodsItemAction addGoodsItemAction;
    private final AddLineAction addLineAction;
    private final SaveAction saveAction;
    private final Class<?>[] FORMS = new Class[]{SpediFront.class, Eur1Front.class, Eur1Back.class, BillLayout1.class, DeliveryNoteLayout1.class, CmrDeFr.class, CmrEnFr.class, EmergencyHeader.class, EmergencyItems.class, UZlayout1.class, BGFront.class, BGBack.class, ItemListFormFront.class};
    private final DeleteAction deleteAction;
    private EditorModel model;
    private final JFrame frame;

    public EditorPanel(final JFrame frame, EditorModel model) {
        this.frame = frame;
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.addLabelAction = new AddLabelAction(this);
        this.addNodeAction = new AddNodeAction(this);
        this.addGoodsItemAction = new AddGoodsItemAction(this);
        this.addLineAction = new AddLineAction(this);
        this.saveAction = new SaveAction(this);
        this.deleteAction = new DeleteAction(this);
        this.setLayout(new BorderLayout());
        this.createMenu(frame);
        this.setModel(model);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                if (EditorPanel.this.testExit()) {
                    frame.dispose();
                }
            }
        });
    }

    public void setModel(EditorModel model) {
        this.model = model;
        this.removeAll();
        this.add(this.createToolBar(), "North");
        JSplitPane pane = new JSplitPane(1);
        pane.add(new PropertiesContainer(model));
        pane.add(new JScrollPane(new CenterPanel(model)));
        this.add(pane);
        this.revalidate();
        this.repaint();
    }

    private Component createToolBar() {
        JToolBar result = new JToolBar();
        result.setFloatable(false);
        result.add(this.addLabelAction);
        result.add(this.addNodeAction);
        result.add(this.addGoodsItemAction);
        result.add(this.addLineAction);
        result.addSeparator();
        result.add(this.deleteAction);
        return result;
    }

    private void createMenu(JFrame frame) {
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.saveAction);
        fileMenu.add(this.deleteAction);
        fileMenu.addSeparator();
        fileMenu.add(this.addLabelAction);
        fileMenu.add(this.addNodeAction);
        fileMenu.add(this.addGoodsItemAction);
        fileMenu.add(this.addLineAction);
        menubar.add(fileMenu);
        JMenu formMenu = new JMenu("Forms");
        for (Class<?> current : this.FORMS) {
            try {
                IFormPageDesc form = (IFormPageDesc)current.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                formMenu.add(new ChangeFormAction(this, form));
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        menubar.add(formMenu);
        frame.setJMenuBar(menubar);
    }

    public boolean testExit() {
        if (!this.model.hasPendingChanges()) {
            return true;
        }
        switch (DialogUtil.showSaveDialogt(this.frame, Services.getText(204), Services.getText(203))) {
            case 0: {
                this.saveCurrentSending();
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private void saveCurrentSending() {
        this.model.save();
    }

    public EditorModel getModel() {
        return this.model;
    }
}

