/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.editor.gui.controls;

import ch.transsoft.edec.model.infra.annotation.listType;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PathFactory {
    public static List<String> getPath(Class<?> root) {
        return PathFactory.createPath(root);
    }

    private static List<String> createPath(Class<?> root) {
        ArrayList<String> result = new ArrayList<String>();
        PathFactory.gatherElements(root, "", result);
        Collections.sort(result);
        return result;
    }

    private static void gatherElements(Class<?> klass, String currentPath, ArrayList<String> result) {
        for (Field field : klass.getDeclaredFields()) {
            if (!PathFactory.typeOf(field, INode.class) || !ReflectionUtil.isPersistable(field)) continue;
            Object path = currentPath;
            if (!((String)path).isEmpty()) {
                path = (String)path + "/";
            }
            path = (String)path + field.getName();
            result.add((String)path);
            if (PathFactory.typeOf(field, ListNode.class)) {
                PathFactory.gatherElements(field.getAnnotation(listType.class).value(), (String)path, result);
                continue;
            }
            PathFactory.gatherElements(field.getType(), (String)path, result);
        }
    }

    private static boolean typeOf(Field field, Class<?> klass) {
        return klass.isAssignableFrom(field.getType());
    }
}

