/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.editor.gui.line;

import ch.transsoft.edec.service.form.desc.FormPageDesc;
import ch.transsoft.edec.service.form.desc.LineDesc;
import ch.transsoft.edec.service.form.editor.gui.controls.Element;
import ch.transsoft.edec.service.form.editor.gui.line.LineEditor;
import ch.transsoft.edec.service.form.editor.gui.line.LinePanel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class LineControl
extends Element {
    private final LineDesc desc;
    private LinePanel result;

    public LineControl(LineDesc desc) {
        this.desc = desc;
        desc.addChangeListener((source, info) -> this.setState());
    }

    @Override
    public JComponent createComponent() {
        this.result = new LinePanel(this.desc);
        this.setState();
        this.result.setBorder(new EmptyBorder(0, 0, 0, 0));
        return this.result;
    }

    private void setState() {
        this.result.setBackground(this.desc.getColorValue());
        this.result.setBounds(this.getX() - 5, this.getY() - 5, this.getWidth() + 10, this.getHeight() + 10);
    }

    @Override
    public JPanel getEditor() {
        return new LineEditor(this.desc);
    }

    @Override
    public void setHasFocus(boolean value) {
        this.result.setHasFocus(value);
        this.result.repaint();
    }

    @Override
    public int getHeight() {
        return this.scale(this.desc.getHeight());
    }

    @Override
    public int getWidth() {
        return this.scale(this.desc.getWidth());
    }

    @Override
    public int getX() {
        return this.scale(this.desc.getX());
    }

    @Override
    public int getY() {
        return this.scale(this.desc.getY());
    }

    @Override
    public void remove(FormPageDesc formPageDesc) {
        formPageDesc.getLines().remove(this.desc);
    }

    @Override
    public void setX(int px) {
        this.desc.getX().setValue(this.unitConverter.mmx(px + 5));
    }

    @Override
    public void setY(int py) {
        this.desc.getY().setValue(this.unitConverter.mmy(py + 5));
    }
}

