/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.form.forms.bill;

import ch.transsoft.edec.model.infra.AddressRenderer;
import ch.transsoft.edec.model.infra.IAddress;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.forms.Bill;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.form.AbstractFormPageDesc;
import ch.transsoft.edec.service.form.desc.Fonts;
import ch.transsoft.edec.service.form.editor.gui.controls.BooleanField;
import ch.transsoft.edec.service.form.render.IDataContext;
import ch.transsoft.edec.service.form.render.IRenderContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.gui.control.DateField;
import ch.transsoft.edec.ui.gui.control.Label;
import ch.transsoft.edec.ui.gui.control.StringArea;
import ch.transsoft.edec.ui.gui.control.StringField;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.ui.pm.model.DatePm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.NumberUtil;
import ch.transsoft.edec.util.disposable.Disposables;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public abstract class BillLayoutBase
extends AbstractFormPageDesc {
    private static final int RADIO_GAP = 0;
    private static final int ROW_LIMIT_FOR_FREE_TEXT = 8;
    private static final int FREE_TEXT_X = 32;
    private static final int FREE_TEXT_Y = 169;
    private static final int FREE_TEXT_WIDTH = 130;
    private static final int FREE_TEXT_HEIGHT = 8;
    private static final int TEXT_X = 30;
    private static final int TEXT_Y = 225;
    private static final int TEXT_WIDTH = 162;
    private static final int TEXT_SMALL_ROWS = 3;
    private static final int TEXT_LARGE_ROWS = 14;
    private DateField date;
    private StringField name;
    private BooleanField declarantAsNameCheckbox;
    private StringPm namePm;
    private StringPm declarantPm;
    private StringField cumulationCountry;
    private JRadioButton noCumulation;
    private JRadioButton cumulation;
    private StringArea textSmall;
    private StringArea textLarge;

    public BillLayoutBase() {
        super(Sending.FormName.bill);
    }

    @Override
    public String getPrintName() {
        return Services.getText(709);
    }

    @Override
    public URL getDescUrl() {
        return this.getClass().getResource("spec.xml");
    }

    @Override
    public double getLineHeight() {
        return 4.5;
    }

    @Override
    public int getLinesPerPage() {
        return 14;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.getIcon("icon/forms/white.png");
    }

    @Override
    public void addControls(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        this.addFreeText(disposables, sending, panel, c2);
        this.addBillTypeRadioGroup(disposables, sending, panel, c2);
        this.addShowWeights(disposables, sending, panel, c2);
        this.addFooter(disposables, sending, panel, c2);
        this.addCheckboxes(panel, c2, sending, disposables);
        this.addTextSmallOrLarge(panel, c2, sending, disposables);
    }

    private void addTextSmallOrLarge(PageContentPanel panel, IUnitConverter c2, Sending sending, Disposables disposables) {
        this.textSmall = this.addStringArea(disposables, sending.getForms().getBill().getFreeTextBottom(), panel, c2, 30, 225, 162, 3);
        this.textLarge = this.addStringArea(disposables, sending.getForms().getBill().getFreeTextBottomLarge(), panel, c2, 30, 225, 162, 14);
        this.setTextSmallOrLargeState(sending);
    }

    private void setTextSmallOrLargeState(Sending sending) {
        if (this.isLargeFreeText(sending)) {
            this.textSmall.setVisible(false);
            this.textLarge.setVisible(true);
        } else {
            this.textSmall.setVisible(true);
            this.textLarge.setVisible(false);
        }
    }

    private boolean isLargeFreeText(Sending sending) {
        return !sending.getForms().getBill().getFooter().isInitialized() || sending.getForms().getBill().isUrsprungsland();
    }

    private void addCheckboxes(PageContentPanel panel, IUnitConverter c2, Sending sending, Disposables disposables) {
        BooleanNode node = sending.getForms().getBill().getDescriptionInEnglish();
        this.addCheckBox(disposables, panel, c2, Services.getText(738), node, 122.0, 10.0);
        node = sending.getForms().getBill().getShowAdditianalUnit();
        this.addCheckBox(disposables, panel, c2, Services.getText(739), node, 122.0, 15.0);
        node = sending.getForms().getBill().getIdInsteadMark();
        this.addCheckBox(disposables, panel, c2, Services.getText(744), node, 122.0, 20.0);
    }

    private void addFreeText(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        StringArea freeText = this.addStringArea(disposables, sending.getForms().getBill().getFreeTextGoods(), panel, c2, 32, 169, 130, 8);
        this.addRowsListener(disposables, panel.getDataContext(), freeText, 8);
    }

    private void addFooter(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton countryRadio = this.addHtmlRadioButton(panel, c2, radioGroup, 0.0, 252.0, Services.getText(712));
        JRadioButton prefEur1Radio = this.addHtmlRadioButton(panel, c2, radioGroup, 0.0, 260.0, Services.getText(713));
        JRadioButton prefEurMedRadio = this.addHtmlRadioButton(panel, c2, radioGroup, 0.0, 270.0, Services.getText(714));
        this.connectRadio(disposables, radioGroup, sending.getForms().getBill().getFooter(), countryRadio, prefEur1Radio, prefEurMedRadio);
        StringPm countryPanelPm = new StringPm(sending.getForms().getBill().getCountryOfOrigin());
        disposables.add(countryPanelPm);
        StringField countryPanel = this.addStringField(countryPanelPm);
        countryPanel.setBounds(new Rectangle(c2.px(60.0), c2.py(216.0), c2.px(132.0), c2.py(4.0)));
        panel.add((Component)countryPanel, "growx, wrap");
        JPanel prefPanel = this.createPrefPanel(disposables, sending, c2);
        panel.add(prefPanel);
        this.updateFooterState(sending, countryPanel, prefPanel, countryRadio, prefEur1Radio, prefEurMedRadio);
        ActionListener listener = e2 -> this.updateFooterState(sending, countryPanel, prefPanel, countryRadio, prefEur1Radio, prefEurMedRadio);
        countryRadio.addActionListener(listener);
        prefEur1Radio.addActionListener(listener);
        prefEurMedRadio.addActionListener(listener);
    }

    private void updateFooterState(Sending sending, StringField countryPanel, JPanel prefPanel, JRadioButton countryRadio, JRadioButton prefRadio, JRadioButton prefEurMedRadio) {
        SwingUtilities.invokeLater(() -> {
            countryPanel.setVisible(countryRadio.isSelected());
            prefPanel.setVisible(prefRadio.isSelected() || prefEurMedRadio.isSelected());
            this.updatePrefFields(sending);
            this.setTextSmallOrLargeState(sending);
        });
    }

    private JPanel createPrefPanel(Disposables disposables, Sending sending, IUnitConverter c2) {
        double X_LABEL = 2.4;
        double Y0_LABEL = 4.7;
        double X_FIELD = 42.0;
        double Y0_FIELD = 4.0;
        double WIDTH_FIELD = 51.0;
        double GAP_Y = 5.5;
        JPanel result = new JPanel();
        result.setOpaque(false);
        result.setLayout(null);
        TitledBorder titledBorder = new TitledBorder(Services.getText(715));
        titledBorder.setTitleFont(c2.getFont(Fonts.font8bold));
        result.setBorder(titledBorder);
        Label labelOrigin = new Label(Services.getText(698));
        labelOrigin.setFont(c2.getFont(Fonts.font8));
        labelOrigin.setLocation(c2.px(X_LABEL), c2.py(Y0_LABEL));
        this.setPreferredComponentSize(labelOrigin);
        result.add(labelOrigin);
        StringPm fieldPm = new StringPm(sending.getForms().getBill().getPerfCountryOfOrigin());
        disposables.add(fieldPm);
        StringField field = this.addStringField(fieldPm);
        field.setFont(c2.getFont(Fonts.font8));
        field.setLocation(c2.px(X_FIELD), c2.py(Y0_FIELD));
        this.setComponentWidth(field, c2, WIDTH_FIELD);
        result.add(field);
        Label labelDate = new Label(Services.getText(718));
        labelDate.setFont(c2.getFont(Fonts.font8));
        labelDate.setLocation(c2.px(X_LABEL), c2.py(Y0_LABEL + GAP_Y));
        this.setPreferredComponentSize(labelDate);
        result.add(labelDate);
        DatePm datePm = new DatePm(sending.getForms().getBill().getDateBottom());
        disposables.add(datePm);
        this.date = new DateField(datePm);
        this.date.setFont(c2.getFont(Fonts.font8));
        this.date.setLocation(c2.px(X_FIELD), c2.py(Y0_FIELD + GAP_Y));
        this.setComponentWidth(this.date, c2, WIDTH_FIELD);
        result.add(this.date);
        Label labelName = new Label(Services.getText(719));
        labelName.setFont(c2.getFont(Fonts.font8));
        labelName.setLocation(c2.px(X_LABEL), c2.py(Y0_LABEL + 2.0 * GAP_Y));
        this.setPreferredComponentSize(labelName);
        result.add(labelName);
        this.namePm = new StringPm(sending.getForms().getBill().getNameBottom());
        disposables.add(this.namePm);
        this.declarantPm = new StringPm(sending.getGoodsDeclaration().getDeclarant().getDeclarantName());
        disposables.add(this.declarantPm);
        this.name = new StringField();
        this.name.setFont(c2.getFont(Fonts.font8));
        this.name.setLocation(c2.px(X_FIELD), c2.py(Y0_FIELD + 2.0 * GAP_Y));
        this.setComponentWidth(this.name, c2, WIDTH_FIELD);
        result.add(this.name);
        BooleanNode declarantAsName = sending.getForms().getBill().getDeclarantAsName();
        this.declarantAsNameCheckbox = this.addCheckBox(disposables, result, c2, "", declarantAsName, 180.0, 249.0);
        this.declarantAsNameCheckbox.setToolTipText("Deklarant-Name aus Kopfdaten verwenden");
        this.declarantAsNameCheckbox.setLocation(c2.px(X_FIELD + WIDTH_FIELD), c2.py(Y0_FIELD + 2.0 * GAP_Y));
        disposables.add(declarantAsName.addChangeListener((source, info) -> this.updateReference(sending)));
        this.updateReference(sending);
        ButtonGroup radioGroup = new ButtonGroup();
        this.cumulation = this.addRadioButton(result, c2, radioGroup, 1.0, 10.0, "Cumulation applied with");
        this.cumulation.setLocation(c2.px(X_LABEL - 1.0), c2.py(Y0_FIELD + 3.0 * GAP_Y) - this.cumulation.getHeight() / 8);
        StringPm cumulationCountryPm = new StringPm(sending.getForms().getBill().getCumulationCountry());
        disposables.add(cumulationCountryPm);
        this.cumulationCountry = this.addStringField(cumulationCountryPm);
        this.cumulationCountry.setFont(c2.getFont(Fonts.font8));
        this.cumulationCountry.setLocation(c2.px(X_FIELD), c2.py(Y0_FIELD + 3.0 * GAP_Y));
        this.setComponentWidth(this.cumulationCountry, c2, WIDTH_FIELD);
        result.add(this.cumulationCountry);
        this.noCumulation = this.addRadioButton(c2, radioGroup, 1.0, 13.0, "No cumulation applied");
        this.noCumulation.setLocation(c2.px(X_FIELD + WIDTH_FIELD), c2.py(Y0_FIELD + 3.0 * GAP_Y) - this.cumulation.getHeight() / 8);
        result.add(this.noCumulation);
        this.connectRadio(disposables, null, sending.getForms().getBill().getCumulationApplied(), this.cumulation, this.noCumulation);
        this.updatePrefFields(sending);
        result.setBounds(new Rectangle(c2.px(30.0), c2.py(252.0), c2.px(162.5), c2.py(27.0)));
        return result;
    }

    private void setComponentWidth(JTextField jTextField, IUnitConverter uc, double width) {
        float HEIGHT_MARGIN = 1.2f;
        jTextField.setSize(uc.px(width), (int)((double)HEIGHT_MARGIN * jTextField.getPreferredSize().getHeight()));
    }

    private void updateReference(Sending sending) {
        if (sending.getForms().getBill().getDeclarantAsName().getValue().booleanValue()) {
            this.name.setModel(this.declarantPm);
            this.name.setReadOnly(true);
        } else {
            this.name.setModel(this.namePm);
            this.name.setReadOnly(false);
        }
    }

    private void updatePrefFields(Sending sending) {
        StringNode auth = sending.getGoodsDeclaration().getConsignor().getAuthorizationNumber();
        boolean enabled = !auth.isInitialized();
        this.date.setEnabled(enabled);
        this.name.setEnabled(enabled);
        this.declarantAsNameCheckbox.setEnabled(enabled);
        if (enabled) {
            this.date.setToolTipText(null);
            this.name.setToolTipText(null);
        } else {
            String text = String.format(Services.getText(720), auth.getValue());
            this.date.setToolTipText(text);
            this.name.setToolTipText(text);
        }
        if (!sending.getForms().getBill().getFooter().isInitialized()) {
            return;
        }
        boolean eurMed = sending.getForms().getBill().getFooter().getIntValue() == 2;
        String tooltip = eurMed ? "" : Services.getText(721);
        this.cumulation.setEnabled(eurMed);
        this.cumulation.setToolTipText(tooltip);
        this.noCumulation.setEnabled(eurMed);
        this.noCumulation.setToolTipText(tooltip);
        this.cumulationCountry.setEnabled(eurMed);
        this.cumulationCountry.setToolTipText(tooltip);
    }

    private void addShowWeights(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        BooleanNode node = sending.getForms().getBill().getShowWeights();
        this.addCheckBox(disposables, panel, c2, Services.getText(722), node, 105.0, 206.0);
    }

    private void addBillTypeRadioGroup(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2) {
        ButtonGroup radioGroup = new ButtonGroup();
        JRadioButton billRadio = this.addRadioButton(panel, c2, radioGroup, 0.0, 89.0, Services.getText(723));
        JRadioButton proformaRadio = this.addRadioButton(panel, c2, radioGroup, 0.0, 93.0, Services.getText(724));
        JRadioButton customsRadio = this.addRadioButton(panel, c2, radioGroup, 0.0, 97.0, Services.getText(725));
        this.connectRadio(disposables, null, sending.getForms().getBill().getType(), billRadio, proformaRadio, customsRadio);
    }

    @Override
    public void render(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        this.renderFreeTextField(sending, dataContext, renderContext);
        this.renderFreeTextSmallOrLarge(sending, renderContext);
        this.renderType(sending, renderContext);
        this.renderWeights(sending, goodsItems, dataContext, renderContext);
        this.renderPageNumber(dataContext, renderContext);
        this.renderStatisticalValueTotal(this.getItemList(sending), dataContext, renderContext);
        this.renderCurrency(this.getItemList(sending), renderContext);
        this.renderFooter(sending, renderContext);
        this.renderTexts(sending, renderContext);
    }

    private void renderPageNumber(IDataContext dataContext, IRenderContext renderContext) {
        if (dataContext.getPageCount() == 1) {
            return;
        }
        String pageNumber = dataContext.getCurrentPage() + "/" + dataContext.getPageCount();
        renderContext.drawStringCentered(0.0, 12.0, 210.0, Fonts.font8, Color.BLACK, pageNumber);
    }

    private void renderTexts(Sending sending, IRenderContext rc) {
        if (rc.isScreen()) {
            rc.drawString(120.0, 90.0, Fonts.font8, Color.BLACK, this.getText(sending, 2403));
        }
        if (rc.isScreen()) {
            rc.drawString(165.0, 90.0, Fonts.font8, Color.BLACK, this.getText(sending, 2404));
        }
        rc.drawString(30.0, 103.0, Fonts.font8, Color.BLACK, this.getText(sending, 2400));
        rc.drawString(30.0, 107.0, Fonts.font8, Color.BLACK, this.getText(sending, 2401));
        rc.drawString(30.0, 111.0, Fonts.font8, Color.BLACK, this.getText(sending, 2402));
        rc.drawString(120.0, 103.0, Fonts.font8, Color.BLACK, this.getText(sending, 2405));
        rc.drawString(120.0, 107.0, Fonts.font8, Color.BLACK, this.getText(sending, 2406));
        rc.drawString(120.0, 111.0, Fonts.font8, Color.BLACK, this.getText(sending, 2407));
        rc.drawString(37.0, 120.0, Fonts.font8, Color.BLACK, this.getText(sending, 2416));
        rc.drawString(37.0, 124.0, Fonts.font8, Color.BLACK, this.getText(sending, 2417));
        rc.drawString(54.0, 120.0, Fonts.font8, Color.BLACK, this.getText(sending, this.isIdInsteadMark(sending) ? 2412 : 2409));
        rc.drawString(80.0, 120.0, Fonts.font8, Color.BLACK, this.getText(sending, 2418));
        rc.drawString(80.0, 124.0, Fonts.font8, Color.BLACK, this.getText(sending, 2419));
        rc.drawStringRightAligned(114.0, 120.0, Fonts.font8, Color.BLACK, this.getText(sending, 2420));
        rc.drawString(116.0, 120.0, Fonts.font8, Color.BLACK, this.getText(sending, 2411));
    }

    private void renderFreeTextField(Sending sending, IDataContext dataContext, IRenderContext rc) {
        if (rc.isScreen()) {
            return;
        }
        if (!this.showFreeText(dataContext, 8)) {
            return;
        }
        String text = sending.getForms().getBill().getFreeTextGoods().getValue();
        rc.drawStringWrap(32.0, 169.0, 130.0, Fonts.font8, Color.BLACK, text);
    }

    private void renderFreeTextSmallOrLarge(Sending sending, IRenderContext rc) {
        if (this.isLargeFreeText(sending)) {
            String text = sending.getForms().getBill().getFreeTextBottomLarge().getValue();
            rc.drawStringWrap(30.0, 225.0, 162.0, Fonts.font8, Color.BLACK, text);
        } else {
            String text = sending.getForms().getBill().getFreeTextBottom().getValue();
            rc.drawStringWrap(30.0, 225.0, 162.0, Fonts.font8, Color.BLACK, text);
        }
    }

    private void renderFooter(Sending sending, IRenderContext renderContext) {
        IntegralNode footer = sending.getForms().getBill().getFooter();
        if (!footer.isInitialized()) {
            return;
        }
        if (footer.getIntValue() == 0) {
            this.renderCountryOfOrigin(sending, renderContext);
        }
        if (footer.getIntValue() != 0) {
            this.renderPref(sending, renderContext);
        }
    }

    private void renderPref(Sending sending, IRenderContext rc) {
        Bill bill = sending.getForms().getBill();
        this.renderPrefText(sending, rc);
        this.renderCumulation(rc, bill);
        this.renderFooterFields(sending, rc, bill);
    }

    private void renderCumulation(IRenderContext rc, Bill bill) {
        if (rc.isScreen()) {
            return;
        }
        if (!bill.isPrefEUR_MED()) {
            return;
        }
        Object text = bill.getCumulationApplied().getIntValue() == 0 ? "- cumulation applied with " + bill.getCumulationCountry().getValue() : "- no cumulation applied";
        rc.drawString(30.0, 255.0, Fonts.font9bold, Color.BLACK, new String[]{text});
    }

    private void renderFooterFields(Sending sending, IRenderContext rc, Bill bill) {
        if (rc.isScreen()) {
            return;
        }
        if (sending.getGoodsDeclaration().getConsignor().getAuthorizationNumber().isInitialized()) {
            return;
        }
        int gap = 265;
        rc.drawString(30.0, 268.0, Fonts.font8, Color.BLACK, this.getText(sending, 726));
        rc.drawString(40.0, 267.0, Fonts.font10, Color.BLACK, bill.getDateBottom().getStringValue());
        rc.drawString(70.0, 268.0, Fonts.font8, Color.BLACK, this.getText(sending, 727));
        String nameStr = bill.getDeclarantAsName().getValue() != false ? sending.getGoodsDeclaration().getDeclarant().getDeclarantName().getStringValue() : bill.getNameBottom().getStringValue();
        rc.drawString(80.0, 267.0, Fonts.font10, Color.BLACK, nameStr);
        rc.drawString(126.0, 268.0, Fonts.font8, Color.BLACK, this.getText(sending, 728));
        rc.drawLine(142.0, 271.5, 192.0, 271.5, 0.5, Color.BLACK);
    }

    private void renderPrefText(Sending sending, IRenderContext rc) {
        String text = this.getAuthText(sending);
        rc.drawStringWrap(30.0, 238.0, 160.0, Fonts.font9bold, Color.BLACK, text);
    }

    private String getAuthText(Sending sending) {
        StringNode auth = sending.getGoodsDeclaration().getConsignor().getAuthorizationNumber();
        String number = auth.isInitialized() ? " (" + this.getText(sending, 729) + " " + auth.getValue() + ")" : "";
        return String.format(this.getText(sending, 711), number, sending.getForms().getBill().getPerfCountryOfOrigin());
    }

    private void renderCountryOfOrigin(Sending sending, IRenderContext rc) {
        rc.drawString(30.0, 216.0, Fonts.font8bold, Color.BLACK, this.getText(sending, 698));
        if (rc.isScreen()) {
            return;
        }
        String text = sending.getForms().getBill().getCountryOfOrigin().getValue();
        rc.drawString(60.0, 216.0, Fonts.font8bold, Color.BLACK, text);
    }

    private void renderWeights(Sending sending, ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        if (!dataContext.isLastPart()) {
            return;
        }
        if (!sending.getForms().getBill().getShowWeights().getValue().booleanValue()) {
            return;
        }
        int fractionDigits = goodsItems.getTotalNetMass().getValue() < 1000.0 ? 3 : 0;
        String gross = NumberUtil.format(fractionDigits, goodsItems.getTotalGrossMass().getValue());
        String net = NumberUtil.format(fractionDigits, goodsItems.getTotalNetMass().getValue());
        renderContext.drawString(30.0, 206.0, Fonts.font8bold, Color.BLACK, this.getText(sending, 730));
        renderContext.drawString(60.0, 206.0, Fonts.font8bold, Color.BLACK, gross);
        renderContext.drawString(30.0, 211.0, Fonts.font8bold, Color.BLACK, this.getText(sending, 731));
        renderContext.drawString(60.0, 211.0, Fonts.font8bold, Color.BLACK, net);
    }

    private void renderCurrency(ItemList itemList, IRenderContext renderContext) {
        renderContext.drawString(158.0, 205.0, Fonts.font8bold, Color.BLACK, itemList.getTotalCurrency().getValue());
    }

    private void renderStatisticalValueTotal(ItemList goodsItems, IDataContext dataContext, IRenderContext renderContext) {
        DecimalNode totalGrossMass = goodsItems.getTotalStatisticalValue(0, dataContext.to());
        renderContext.drawStringRightAligned(190.0, 205.0, Fonts.font8bold, Color.BLACK, totalGrossMass.toString());
    }

    private void renderType(Sending sending, IRenderContext rc) {
        rc.drawString(30.0, 88.0, Fonts.font14bold, Color.BLACK, this.getTypeLine1(sending));
    }

    private String getTypeLine1(Sending sending) {
        switch (sending.getForms().getBill().getType().getIntValue()) {
            case 0: {
                return this.getText(sending, 732);
            }
            case 1: {
                return this.getText(sending, 733);
            }
            case 2: {
                return this.getText(sending, 734);
            }
        }
        throw Check.fail("unexpected bill-type " + sending.getForms().getBill().getType().getIntValue());
    }

    protected void addConsignor(Sending sending, IRenderContext renderContext, double x, double y, boolean showLabel) {
        this.addAddress(sending, sending.getGoodsDeclaration().getConsignor(), 735, renderContext, x, y, showLabel);
    }

    protected void addConsignee(Sending sending, IRenderContext renderContext, double x, double y, boolean showLabel) {
        this.addAddress(sending, sending.getGoodsDeclaration().getConsignee(), 736, renderContext, x, y, showLabel);
    }

    protected void addAddress(Sending sending, IAddress address, int labelTextId, IRenderContext renderContext, double x, double y, boolean showLabel) {
        if (showLabel) {
            renderContext.drawString(x, y - 18.0, Fonts.font12bold, Color.BLACK, this.getText(sending, labelTextId));
        }
        AddressRenderer renderer = address.getAddress();
        renderer.render(renderContext, x, y, Fonts.font11);
    }

    protected void renderTextField(Sending sending, IRenderContext renderContext, double x, double y) {
        if (renderContext.isScreen()) {
            return;
        }
        String text = sending.getForms().getBill().getTextBesideConsignee().getValue();
        renderContext.drawStringWrap(x, y, 60.0, Fonts.font10, Color.BLACK, text);
    }

    protected void addTextBesideConsignee(Disposables disposables, Sending sending, PageContentPanel panel, IUnitConverter c2, double x, double y) {
        StringPm countryPanelPm = new StringPm(sending.getForms().getBill().getTextBesideConsignee());
        disposables.add(countryPanelPm);
        StringArea countryPanel = new StringArea(countryPanelPm, 8);
        countryPanel.getTextArea().setFont(c2.getFont(Fonts.font10));
        countryPanel.setBounds(new Rectangle(c2.px(x), c2.py(y), c2.px(60.0), c2.py(36.0)));
        panel.add(countryPanel);
    }

    private String getText(Sending sending, int id) {
        if (this.isBillEnglish(sending)) {
            return Services.get(ITextService.class).getText(ITextService.Language.en, id);
        }
        return Services.getText(id);
    }

    private boolean isBillEnglish(Sending sending) {
        return sending.getForms().getBill().getDescriptionInEnglish().getPrimitiveValue();
    }

    private boolean isIdInsteadMark(Sending sending) {
        return sending.getForms().getBill().getIdInsteadMark().getPrimitiveValue();
    }
}

